<?php
$v->layout("_themesis");
?>
<div class="container-fluid nav-hidden" id="content">
    <div id="">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-title">
                            <h3>
                                Sped
                                <a href="<?php echo url('sped/index');?>" class="btn btn-primary">VOLTAR</a>
                            </h3>
                        </div>
                        <div class="box-content">
                            <form name="formUpload" id="formUpload" method="post" enctype="multipart/form-data">
                                <fieldset>
                                    <div class="row">
                                        <div class="form-group col-lg-3">
                                            <label>REFERÊNCIA</label>
                                            <input type="text" class="form-control referencia_faturamento_mask" name="sped_arquivo_referencia" autocomplete="off"/>
                                        </div>
                                        <div class="form-group col-lg-9">
                                            <label>EMPRESA</label>
                                            <input type="hidden" class="autocomplete_company_completo_id" name="sped_arquivo_id_company"/>
                                            <input type="text" class="form-control autocomplete_company_completo" onblur="set_blank();" autocomplete="off"/>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-lg-6">
                                            <label>SPED FISCAL</label>
                                            <input type="file" class="form-control" name="fiscal" />
                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label>SPED CONTRIBUIÇÕES</label>
                                            <input type="file" class="form-control" name="contribuicao" />
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-lg-12" align="right">
                                        <input type="button" id="btnEnviar" class="btn btn-primary" value="GRAVAR" />
                                        </div>
                                    </div>
                                </fieldset>
                            </form>
                            <div class="row">
                                <div class="form-group col-lg-12">
                                    <div class="progress">
                                        <div>
                                            <span id="porcentagem" class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="10" aria-valuemin="0" aria-valuemax="100" style="width: 100%">0%</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $v->start("scripts"); ?>
<script type="text/javascript">
    function set_blank(){
        var name = $(".autocomplete_company_completo").val();
        if(name == ''){
            $(".autocomplete_company_completo_id").val('');
        }
    }
    $(document).ready(function(){
        $('#btnEnviar').click(function(){
            load_in();
            $('#formUpload').ajaxForm({
                uploadProgress: function(event, position, total, percentComplete) {
                    $('.progress-bar .progress-bar-success').attr('aria-valuenow',percentComplete);
                    $('progress').attr('value',percentComplete);
                    $('#porcentagem').html(percentComplete+'% Enviado');
                    $('#resposta').html('<div class="alert alert-success"><img src="_img/load.gif" class="load" /> <strong>Aguarde!</strong> Estou enviando o arquivo</div>');
                },
                success: function(data) {
                    if(data[0].type === 'ok'){
                        load_out();
                        $('progress').attr('value','100');
                        $('#porcentagem').html('100%');
                        setTimeout(function(){
                            if(data[0].type === 'ok'){
                                notify(data[0].title,data[0].message);
                                $('#resposta').html('<div class="alert alert-success"><strong>Parabéns!</strong> Arquivo enviado</div>');
                                $('#porcentagem').html('0%');
                            }else{
                                notify(data[0].title,data[0].message);
                                
                            }
                        }, 500);
                    }else{
                        $('progress').attr('value','0');
                        $('#porcentagem').html('0%');
                        setTimeout(function(){
                            notify(data[0].title,data[0].message);                            
                        }, 500);
                    }
                },
                error : function(){
                    load_out();
                },
                dataType: 'json',
                url: '<?= $router->route("sped.insert"); ?>',
                resetForm: false
            }).submit();
        });
    });
</script>
<?php $v->end(); ?>
