<?php
$v->layout("_themesis");
?>
<div class="container-fluid nav-hidden" id="content">
    <div id="">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-title">
                            <h3>
                                Contato
                            </h3>
                        </div>
                        <div class="box-content">
                            <form class="wc_form_search" action="" method="POST">
                                <fieldset>
                                    <div class="row">
                                        <div class="form-group col-lg-3">
                                            <label>NOME RAZÃO</label>
                                            <input type="text" class="form-control" name="name" autocomplete="off"/>
                                        </div>
                                        <div class="form-group col-lg-2">
                                            <label>NOME FANTASIA</label>
                                            <input type="text" class="form-control" name="fantasy" autocomplete="off"/>
                                        </div>
                                        <div class="form-group col-lg-2">
                                            <label>CPF / CNPJ</label>
                                            <input type="text" class="form-control" name="cpf_cnpj" autocomplete="off"/>
                                        </div>
                                        <div class="form-group col-lg-2">
                                            <label>STATUS</label>
                                            <select name="status" class="form-control">
                                                <option value=""></option>
                                                <option value="0">ATIVO</option>
                                                <option value="1">INATIVO</option>
                                            </select>
                                        </div>
                                        <div class="form-group col-lg-3">
                                            <label>EMAIL</label>
                                            <input type="text" class="form-control" name="email" autocomplete="off"/>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-lg-7">
                                            <label>.</label><br />
                                            <button class="btn btn-primary">PESQUISAR</button>
                                            <a class="btn btn-primary" onclick="link_update();">EDITAR</a>
                                            <a class="btn btn-danger" onclick="link_delete();">DELETAR</a>
                                            <a class="btn btn-blue" onclick="link_certificate();">CERTIFICADO DIGITAL</a>
                                            <a class="btn btn-brown" onclick="link_webservice();">DOWNLOAD WEBSERVICE</a>
                                            <a class="btn btn-success" href="<?php echo url('company/create');?>">CADASTRAR NOVO</a>
                                        </div>
                                    </div>
                                </fieldset>
                            </form>
                            <hr />
                            <div id="load_company"></div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="box box-color blue box-condensed box-bordered">
                                        <div class="box-title" align="center">
                                            <h3>
                                                QUANTIDADE
                                            </h3>
                                        </div>
                                        <div class="box-content">
                                            <div id="company_quantify" align="center"><h4></h4></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    var selectionFormatter = function(value, data, cell, row, options, formatterParams){
        var rowSelect = $("<input type='checkbox' class='row-select' value='"+data.company_id+"'>");

        rowSelect.on("change", function(){
            if($(this).is(":checked")){
                $(this).closest(".tabulator-row").addClass("selected");
            }else{
                $(this).closest(".tabulator-row").removeClass("selected");
            }
        });
        return rowSelect;
    }
    $("#load_company").tabulator({
        height: "450px",
        fitColumns: true,
        ajaxURL: "<?= $router->route("company.select"); ?>",
        ajaxParams: {action: "search_company"},
        pagination: "remote",
        paginationSize: 100,
        paginationDataSent: {"page": "pageNo"},
        columns: [
            {title:"<input type='checkbox' class='select-all'>", formatter:selectionFormatter, width: 35},
            {title: "ID", field: "company_id", sorter: "int", width: 75},
            {title: "NOME / RAZÃO", field: "company_name", sorter: "string"},
            {title: "NOME / FANTASIA", field: "company_fantasy", sorter: "string"},
            {title: "CPF / CNPJ", field: "company_cpf_cnpj", sorter: "string"},
            {title: "TELEFONE", field: "company_phone", sorter: "string"},
            {title: "CELULAR", field: "company_cell", sorter: "string"},
            {title: "EMAIL", field: "company_email", sorter: "string"},
            {title: "STATUS", field: "company_status", sorter: "string"},
            {title: "ULTIMA CONSULTA", field: "company_ult_date_nfe_primary", sorter: "string"},
        ],
        ajaxResponse:function(url, params, response){
            $("#company_quantify").html('<h4>'+response.quantify+'</h4>');
            return response;
        }
    });
    $("#load_company .select-all").on("change", function(){
        if($(this).is(":checked")){
            $("#load_company .row-select").prop("checked", true).closest(".tabulator-row").addClass("selected");
        }else{
            $("#load_company .row-select").prop("checked", false).closest(".tabulator-row").removeClass("selected");
        }
    });
    $('.wc_form_search').submit(function () {
        var Form = $(this);
        var Param = "&action=search_company";
        var Data = Form.serialize()+Param;


        $.ajax({
            url: "<?= $router->route("company.search"); ?>",
            data: Data,
            type: 'POST',
            dataType: 'json',
            beforeSend: load_in(),
            success: function (data) {
                redirect('<?php echo url('company/index');?>');
                load_out();
            },
            error: function (request, status, error) {
                notify('Opss', 'Operação não pode ser finalizada!!');
            }
        });
        return false;
    });
    function load_search(){
        var Data = "&action=search_company";
        $.ajax({
            url: "<?= $router->route("company.searchRead"); ?>",
            data: Data,
            type: 'POST',
            dataType: 'json',
            beforeSend: load_in(),
            success: function (data) {
                if(data.type === 'ok'){
                    var Form = $(".wc_form_search");
                    $.each(data.info, function (key, value) {
                        Form.find("input[name='" + key + "'], select[name='" + key + "']").val(value);
                    });
                }
                load_out();
            },
            error: function (request, status, error) {
                load_out();
            }
        });
        return false;
    }
    function link_certificate(){
        var objCheckBox = $("#load_company .row-select");
        var sel = 0;
        var selecionadas = "";
        for (i=0; i < objCheckBox.length; i++) {
            if (objCheckBox[i].checked) {
                sel++;
                selecionadas += objCheckBox[i].value+",";
            }
        }
        if(Number(sel) === 0){
            notify('Ops', 'É preciso selecionar um registro');
        }else if(Number(sel) > 1){
            notify('Ops', 'É preciso selecionar apenas um registro');
        }else{
            var url = selecionadas.substr(0,(selecionadas.length - 1));
            window.location = '<?php echo url('company/certificate/');?>'+url;
        }
    }
    function link_webservice(){
        var objCheckBox = $("#load_company .row-select");
        var sel = 0;
        var selecionadas = "";
        for (i=0; i < objCheckBox.length; i++) {
            if (objCheckBox[i].checked) {
                sel++;
                selecionadas += objCheckBox[i].value+",";
            }
        }
        if(Number(sel) === 0){
            notify('Ops', 'É preciso selecionar um registro');
        }else if(Number(sel) > 1){
            notify('Ops', 'É preciso selecionar apenas um registro');
        }else{
            var url = selecionadas.substr(0,(selecionadas.length - 1));
            window.location = '<?php echo url('company/download/');?>'+url;
        }
    }
    function link_update(){
        var objCheckBox = $("#load_company .row-select");
        var sel = 0;
        var selecionadas = "";
        for (i=0; i < objCheckBox.length; i++) {
            if (objCheckBox[i].checked) {
                sel++;
                selecionadas += objCheckBox[i].value+",";
            }
        }
        if(Number(sel) === 0){
            notify('Ops', 'É preciso selecionar um registro');
        }else if(Number(sel) > 1){
            notify('Ops', 'É preciso selecionar apenas um registro');
        }else{
            var url = selecionadas.substr(0,(selecionadas.length - 1));
            window.location = '<?php echo url('company/update/');?>'+url;
        }
    }
    function link_delete(){
        var objCheckBox = $("#load_company .row-select");
        var sel = 0;
        var selecionadas = "";
        for (i=0; i < objCheckBox.length; i++) {
            if (objCheckBox[i].checked) {
                sel++;
                selecionadas += objCheckBox[i].value+",";
            }
        }
        if(Number(sel) === 0){
            notify('Ops', 'É preciso selecionar um registro');
        }else if(Number(sel) > 1){
            notify('Ops', 'É preciso selecionar apenas um registro');
        }else{
            var url = selecionadas.substr(0,(selecionadas.length - 1));
            window.location = '<?php echo url('company/delete/');?>'+url;
        }
    }
    $(function(){
        load_search();
    });
</script>
