<?php
$v->layout("_themesis");
?>
<div class="container-fluid nav-hidden" id="content">
    <div id="">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-title">
                            <h3>
                                Contato
                                <a href="<?php echo url('company/index');?>" class="btn btn-primary">VOLTAR</a>
                            </h3>
                        </div>
                        <div class="box-content">
                            <form class="wc_form" action="" method="POST">
                                <fieldset>
                                    <div class="row">
                                        <div class="form-group col-lg-4">
                                            <label>NOME RAZÃO</label>
                                            <input type="text" class="form-control" name="company_name" autocomplete="off"/>
                                        </div>
                                        <div class="form-group col-lg-4">
                                            <label>NOME FANTASIA</label>
                                            <input type="text" class="form-control" name="company_fantasy" autocomplete="off"/>
                                        </div>
                                        <div class="form-group col-lg-2">
                                            <label>CPF / CNPJ</label>
                                            <input type="text" class="form-control" name="company_cpf_cnpj" autocomplete="off"/>
                                        </div>
                                        <div class="form-group col-lg-2">
                                            <label>STATUS</label>
                                            <select name="company_status" class="form-control">
                                                <option value="0">ATIVO</option>
                                                <option value="1">INATIVO</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-lg-2">
                                            <label>NASCIMENTO</label>
                                            <input type="date" class="form-control" name="company_birth_date" autocomplete="off" />
                                        </div>
                                        <div class="form-group col-lg-2">
                                            <label>TELEFONE</label>
                                            <input type="text" class="form-control mask_telefone" name="company_phone" autocomplete="off" />
                                        </div>
                                        <div class="form-group col-lg-2">
                                            <label>CELULAR</label>
                                            <input type="text" class="form-control mask_telefone" name="company_cell" autocomplete="off" />
                                        </div>
                                        <div class="form-group col-lg-4">
                                            <label>EMAIL</label>
                                            <input type="text" class="form-control" name="company_email" autocomplete="off" />
                                        </div>
                                        <div class="form-group col-lg-2">
                                            <label>CEP</label>
                                            <div class="input-group">
                                                <input type="text" class="form-control mask_cep cep" name="company_cep" autocomplete="off" />
                                                <div class="input-group-btn">
                                                    <button class="btn" type="button" onclick="send_cep();">OK</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-lg-4">
                                            <label>ENDEREÇO</label>
                                            <input type="text" class="form-control rua" name="company_address" autocomplete="off" />
                                        </div>
                                        <div class="form-group col-lg-2">
                                            <label>NÚMERO</label>
                                            <input type="text" class="form-control" name="company_number" autocomplete="off" />
                                        </div>
                                        <div class="form-group col-lg-4">
                                            <label>COMPLEMENTO</label>
                                            <input type="text" class="form-control" name="company_complement" autocomplete="off" />
                                        </div>
                                        <div class="form-group col-lg-2">
                                            <label>BAIRRO</label>
                                            <input type="text" class="form-control bairro" name="company_district" autocomplete="off" />
                                        </div>
                                    </div>
                                    <div class="row">

                                        <div class="form-group col-lg-2">
                                            <label>CIDADE</label>
                                            <input type="text" class="form-control cidade" name="company_city" autocomplete="off" />
                                            <input type="hidden" class="form-control ibge" name="company_city_ibge" />
                                        </div>
                                        <div class="form-group col-lg-2">
                                            <label>UF</label>
                                            <select name="company_uf" class="form-control uf">
                                                <option value=""></option>
                                                <option value="AC">Acre</option>
                                                <option value="AL">Alagoas</option>
                                                <option value="AP">Amapá</option>
                                                <option value="AM">Amazonas</option>
                                                <option value="BA">Bahia</option>
                                                <option value="CE">Ceará</option>
                                                <option value="DF">Distrito Federal</option>
                                                <option value="ES">Espírito Santo</option>
                                                <option value="GO">Goiás</option>
                                                <option value="MA">Maranhão</option>
                                                <option value="MT">Mato Grosso</option>
                                                <option value="MS">Mato Grosso do Sul</option>
                                                <option value="MG">Minas Gerais</option>
                                                <option value="PA">Pará</option>
                                                <option value="PB">Paraíba</option>
                                                <option value="PR">Paraná</option>
                                                <option value="PE">Pernambuco</option>
                                                <option value="PI">Piauí</option>
                                                <option value="RJ">Rio de Janeiro</option>
                                                <option value="RN">Rio Grande do Norte</option>
                                                <option value="RS">Rio Grande do Sul</option>
                                                <option value="RO">Rondônia</option>
                                                <option value="RR">Roraima</option>
                                                <option value="SC">Santa Catarina</option>
                                                <option value="SP">São Paulo</option>
                                                <option value="SE">Sergipe</option>
                                                <option value="TO">Tocantins</option>
                                            </select>
                                        </div>

                                        <div class="form-group col-lg-2">
                                            <label>BAIXA NFSE</label>
                                            <select name="company_type_nfse" class="form-control uf">
                                                <option value="0">NÃO</option>
                                                <option value="1">SIM</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-lg-12" align="right">
                                            <button class="btn btn-primary">GRAVAR</button>
                                        </div>
                                    </div>
                                </fieldset>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $v->start("scripts"); ?>
<script type="text/javascript">
    $('.wc_form').submit(function () {
        var Form = $(this);
        var Data = Form.serialize();

        $.ajax({
            url: "<?= $router->route("company.insert"); ?>",
            data: Data,
            type: 'POST',
            dataType: 'json',
            beforeSend: load_in(),
            success: function (data) {
                if(data[0].type === 'error'){
                    notify(data[0].title, data[0].message);
                }else{
                    notify(data[0].title, data[0].message);
                    setTimeOutPage('<?php echo url('company/index');?>');
                }
                load_out();
            },
            error: function (request, status, error) {
                notify('Opss', 'Operação não pode ser finalizada!!');
            }
        });
        return false;
    });
</script>
<?php $v->end(); ?>
