<?php
$v->layout("_themesis");
?>
<div class="container-fluid nav-hidden" id="content">
    <div id="">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-title">
                            <h3>
                                Contato - Certificados
                                <a href="<?php echo url('company/index');?>" class="btn btn-primary">VOLTAR</a>
                            </h3>
                        </div>
                        <div class="box-content">
                            <form class="wc_form form_certificate" action="" method="POST">
                                <fieldset>
                                    <div class="row">
                                        <div class="form-group col-lg-12">
                                            <label>Certificado Digital</label><br />
                                            <input type="file" class="file-manager" id="file" name="file" />
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-lg-12">
                                            <label>Senha</label>
                                            <input type="password" class="form-control certificate_password" name="certificate_password" autocomplete="off"/>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-lg-12" align="right">
                                            <button class="btn btn-primary" type="button" onclick="upload_image();">GRAVAR</button>
                                        </div>
                                    </div>
                                </fieldset>
                            </form>


                            <hr />
                            <div class="load_certificate"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $v->start("scripts"); ?>
<script type="text/javascript">
    function upload_image(){
        var data = new FormData();
        data.append('file', document.getElementById('file').files[0]);
        var certificate_password = $(".certificate_password").val();
        if(certificate_password != ''){
            $.ajax({
                url : '<?= $router->route("company.certificateCreate"); ?>',
                type : 'POST',
                data : data,
                dataType: 'json',
                processData: false,
                contentType: false,
                success : function(data) {
                    if(data[0].type === 'error'){
                        notify(data[0].title, data[0].message);
                    }else{
                        update_certificate(data.id_certificate);
                    }
                }
            });
        }else{
            notify('Opss', 'É necessário inserir a senha');
        }
    }
    function load_certificate(){
        var Data = "&id=<?php echo $param['uri'];?>";
        $.ajax({
            url: "<?= $router->route("company.searchCertificate"); ?>",
            data: Data,
            type: 'POST',
            dataType: 'json',
            beforeSend: load_in(),
            success: function (data) {
                if(data[0].type === 'error'){
                    notify(data[0].title, data[0].message);
                    $(".load_certificate").html('');
                    $(".form_certificate").show();
                }else{
                    $(".load_certificate").html(data.retorno);
                    if(data.count == 1){
                        $(".form_certificate").show();
                    }else{
                        $(".form_certificate").hide();
                    }

                }
                load_out();
            },
            error: function (request, status, error) {
                notify('Opss', 'Operação não pode ser finalizada!');
            }
        });
        return false;
    }
    function delete_certificate(id){
        var Data = "&id="+id;
        $.ajax({
            url: "<?= $router->route("company.certificateDelete"); ?>",
            data: Data,
            type: 'POST',
            dataType: 'json',
            beforeSend: load_in(),
            success: function (data) {
                if(data[0].type === 'error'){
                    notify(data[0].title, data[0].message);
                }else{
                    load_certificate();
                    notify(data[0].title, data[0].message);
                }
                load_out();
            },
            error: function (request, status, error) {
                notify('Opss', 'Operação não pode ser finalizada!', '');
            }
        });
        return false;
    }
    function update_certificate(id){
        var configuracao_senha = $(".certificate_password").val();
        var Data = "&id_contato=<?php echo $param['uri'];?>&senha="+configuracao_senha+"&id="+id;
        $.ajax({
            url: "<?= $router->route("company.certificateUpdate"); ?>",
            data: Data,
            type: 'POST',
            dataType: 'json',
            beforeSend: load_in(),
            success: function (data) {
                if(data[0].type === 'error'){
                    notify(data[0].title, data[0].message);
                }else{
                    load_certificate();
                    notify(data[0].title, data[0].message);
                }
                load_out();
            },
            error: function (request, status, error) {
                notify('Opss', 'Operação não pode ser finalizada!', '');
            }
        });
        return false;
    }
    $(function(){
        load_certificate();
    });
</script>
<?php $v->end(); ?>
