<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <!-- Apple devices fullscreen -->
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <!-- Apple devices fullscreen -->
    <meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

    <title>DOWNLOAD XML</title>

    <link rel="stylesheet" href="<?= asset("/_boot/css/bootstrap.min.css"); ?>">
    <link rel="stylesheet" href="<?= asset("/_boot/css/plugins/jquery-ui/jquery-ui.min.css"); ?>">

    <link rel="stylesheet" href="<?= asset("/_boot/css/plugins/colorbox/colorbox.css"); ?>">


    <link rel="stylesheet" href="<?= asset("/_boot/css/plugins/gritter/jquery.gritter.css"); ?>">
    <link rel="stylesheet" href="<?= asset("/_boot/css/plugins/timepicker/bootstrap-timepicker.min.css"); ?>">
    <link rel="stylesheet" href="<?= asset("/_boot/css/plugins/colorpicker/colorpicker.css"); ?>">
    <link rel="stylesheet" href="<?= asset("/_boot/css/plugins/datepicker/datepicker.css"); ?>">
    <link rel="stylesheet" href="<?= asset("/_boot/css/plugins/daterangepicker/daterangepicker.css"); ?>">
    <link rel="stylesheet" href="<?= asset("/_boot/css/plugins/icheck/all.css"); ?>">
    <link rel="stylesheet" href="<?= asset("/_boot/css/plugins/multiselect/multi-select.css"); ?>">
    <link rel="stylesheet" href="<?= asset("/_boot/css/plugins/chosen/chosen.css"); ?>">
    <link rel="stylesheet" href="<?= asset("/_boot/css/plugins/select2/select2.css"); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.13/css/bootstrap-multiselect.css" />

    <link rel="stylesheet" href="<?= asset("/_boot/css/style.css"); ?>">
    <link rel="stylesheet" href="<?= asset("/_boot/css/themes.css"); ?>">

    <link href="<?= asset("/uploader-master/dist/css/jquery.dm-uploader.min.css"); ?>" rel="stylesheet" />
    <link href="<?= asset("/uploader-master/demo/styles.css"); ?>" rel="stylesheet" />

    <link href="<?= asset("/shadowbox/shadowbox.css"); ?>" rel="stylesheet" />

    <style type="text/css">
        .tabulator-tableHolder{
            overflow:scroll !important;
        }
        .ui-autocomplete {
            max-height: 250px;
            max-width: 35%;
            overflow-y: auto;   /* prevent horizontal scrollbar */
            overflow-x: hidden; /* add padding to account for vertical scrollbar */
            z-index:1000 !important;
        }
    </style>





    <script src="<?= asset("/_boot/js/jquery.min.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/jquery.form.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/nicescroll/jquery.nicescroll.min.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/jquery-ui/jquery-ui.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/imagesLoaded/jquery.imagesloaded.min.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/slimscroll/jquery.slimscroll.min.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/bootstrap.min.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/form/jquery.form.min.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/jquery.maskMoney.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/datepicker/bootstrap-datepicker.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/daterangepicker/moment.min.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/daterangepicker/daterangepicker.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/timepicker/bootstrap-timepicker.min.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/colorpicker/bootstrap-colorpicker.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/bootbox/jquery.bootbox.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/gritter/jquery.gritter.min.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/multiselect/jquery.multi-select.js"); ?>"></script>
    <script src="<?= asset("/_boot/jquery.blockUI.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/ckeditor/ckeditor.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/select2/select2.min.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/chosen/chosen.jquery.min.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/application.min.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/demonstration.min.js"); ?>"></script>



    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.2/bootstrap3-typeahead.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.13/js/bootstrap-multiselect.js"></script>

    <script src="<?= asset("/uploader-master/dist/js/jquery.dm-uploader.min.js"); ?>"></script>
    <script src="<?= asset("/uploader-master/demo/demo-ui.js"); ?>"></script>
    <script src="<?= asset("/uploader-master/demo/demo-config.js"); ?>"></script>

    <script src="<?= asset("/_boot/js/plugins/colorbox/jquery.colorbox-min.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/masonry/jquery.masonry.min.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/plugins/imagesLoaded/jquery.imagesloaded.min.js"); ?>"></script>

    <script src="<?= asset("/shadowbox/shadowbox.js"); ?>"></script>
    <script>
        $(function(){
            Shadowbox.init();
        });
    </script>

    <script>
        function trim(str) {
            return str.replace(/^\s+|\s+$/g, "");
        }
        $(document).ajaxStop($.unblockUI);
        function load_in() {
            $.blockUI({message: '<H1><img src="<?= asset("/load.gif"); ?>" /></H1><H1></H1>'});
        }
        function load_out() {
            $.unblockUI();
        }
        function load_in_new(){
            $(".load_info_new").show();
        }
        function load_out_new(){
            $(".load_info_new").hide();
        }
        function notify(title, text) {
            if(title === 'Ops' || title === 'Opss'){
                var img = '<?= asset("/cancel.png"); ?>';
            }else{
                var img = '<?= asset("/confirm.png"); ?>';
            }
            var unique_id = $.gritter.add({
                title: title,
                image:img,
                text: text,
                sticky: false,
                time: '2000'
            });
            return false;
        }
        $(function(){
            document.body.style.zoom = "90%";
        });
    </script>
    <!-- tabulator -->
    <script type="text/javascript" src="<?= asset("/_boot/tabulator-master/tabulator.js"); ?>"></script>
    <link rel="stylesheet" href="<?= asset("/_boot/tabulator-master/tabulator.css"); ?>">

    <script type="text/javascript" src="<?= asset("/_boot/js/jquery.priceformat.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/jquery.mask.js"); ?>"></script>
    <script src="<?= asset("/_boot/js/jquery.mask.min.js"); ?>"></script>

    <script src="https://code.highcharts.com/highcharts.js"></script>
</head>
<body class="theme-grey" data-theme="theme-balck">
<div id="navigation">
    <div class="container-fluid">
        <ul class='main-nav'>
            <li>
                <a href="<?php echo url();?>">
                    <span>Dashboard</span>
                </a>
            </li>
            <li>
                <a href="#" data-toggle="dropdown" class='dropdown-toggle'>
                    <span>Cadastros</span>
                    <span class="caret"></span>
                </a>
                <ul class="dropdown-menu">
                    <li>
                        <a href="<?php echo url('company/index');?>">Empresas</a>
                    </li>
                </ul>
            </li>
            <li>
                <a href="#" data-toggle="dropdown" class='dropdown-toggle'>
                    <span>Docs Fiscais</span>
                    <span class="caret"></span>
                </a>
                <ul class="dropdown-menu">
                    <li>
                        <a href="<?php echo url('doc_nfe/index');?>">NFe</a>
                    </li>
                    <li>
                        <a href="<?php echo url('doc_nfse/index');?>">NFSe</a>
                    </li>
                </ul>
            </li>
            <li>
                <a href="#" data-toggle="dropdown" class='dropdown-toggle'>
                    <span>SPED</span>
                    <span class="caret"></span>
                </a>
                <ul class="dropdown-menu">
                    <li>
                        <a href="<?php echo url('sped/index');?>">Armazenamento</a>
                    </li>
                </ul>
            </li>
            <li>
                <a href="#" data-toggle="dropdown" class='dropdown-toggle'>
                    <span>Consultas</span>
                    <span class="caret"></span>
                </a>
                <ul class="dropdown-menu">
                    <li>
                        <a href="<?php echo url('consult/index');?>">CNPJ / IE</a>
                    </li>
                </ul>
            </li>
            <li>
                <a href="#" data-toggle="dropdown" class='dropdown-toggle'>
                    <span>XMLs Chave</span>
                    <span class="caret"></span>
                </a>
                <ul class="dropdown-menu">
                    <li>
                        <a href="<?php echo url('xml_key_nfe/index');?>">NFe</a>
                    </li>
                    <li>
                        <a href="<?php echo url('xml_key_nfce/index');?>">NFCe</a>
                    </li>
                    <li>
                        <a href="<?php echo url('xml_key_cte/index');?>">CTe</a>
                    </li>
                </ul>
            </li>
            <li>
                <a href="#" data-toggle="dropdown" class='dropdown-toggle'>
                    <span>Financeiro</span>
                    <span class="caret"></span>
                </a>
                <ul class="dropdown-menu">
                    <li>
                        <a href="<?php echo url('finance/balance');?>">Saldo</a>
                    </li>
                    <li>
                        <a href="<?php echo url('finance/credits');?>">Comprar Créditos</a>
                    </li>
                </ul>
            </li>
            <li style="display: none;">
                <a href="#" data-toggle="dropdown" class='dropdown-toggle'>
                    <span>Relatórios</span>
                    <span class="caret"></span>
                </a>
                <ul class="dropdown-menu">
                    <li>
                        <a href="<?php echo url('report/financeiro');?>">Financeiro</a>
                    </li>
                </ul>
            </li>
            <?php
            if($_SESSION[SESSION]->user_nivel == '0'):
            ?>
            <li style="width: 400px;">
                <a href="#">
                    <input type="text" value="<?php echo $_SESSION['name_user'];?>" class="form-control autocomplete_user" style="height: 20px;">
                    <input type="hidden" value="<?php echo $_SESSION['id_user'];?>" class="form-control autocomplete_user_id" >
                </a>
            </li>
            <li>
                <a href="#" class="btn btn-blue" onclick="set_user();">
                    ABRIR CADASTRO
                </a>
            </li>
            <li>
                <a href="#" class="btn btn-danger" onclick="clear_user();">
                    LIMPAR CADASTRO
                </a>
            </li>
            <?php
            endif;
            ?>
        </ul>
        <div class="user">
            <div class="dropdown">
                <a href="#" class='dropdown-toggle' data-toggle="dropdown">
                    <img src="<?php echo get_gravatar($_SESSION[SESSION]->user_nome);?>" alt="" width="27" height="27">
                </a>
                <ul class="dropdown-menu pull-right">
                    <li>
                        <a href="<?php echo url('logout');?>">Sair</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="container-fluid nav-hidden carregar_paginas" id="content">
    <?= $v->section("content"); ?>
</div>
<script>
    function setTimeOutPage(url){
        setTimeout(function(){
            window.location = url;
        }, 2000);
    }

    function redirect(url){
        window.location = url;
    }

    function empty_cep(){
        $(".rua").val('');
        $(".bairro").val('');
        $(".cidade").val('');
        $(".uf").val('');
        $(".ibge").val('');
    }
    function set_user(){
        var id_user = $(".autocomplete_user_id").val();
        var Data = "&id="+id_user;
        $.ajax({
            url: "<?= url('config/setUser'); ?>",
            data: Data,
            type: 'POST',
            dataType: 'json',
            beforeSend: load_in(),
            success: function (data) {
                if(data[0].type === 'error'){
                    notify(data[0].title, data[0].message);
                }else{
                    notify(data[0].title, data[0].message);
                    setTimeOutPage('<?php echo url();?>');
                }
                load_out();
            },
            error: function (request, status, error) {
                notify('Opss', 'Operação não pode ser finalizada!');
            }
        });
        return false;
    }
    function clear_user(){
        var Data = "&id=0";
        $.ajax({
            url: "<?= url('config/clearUser'); ?>",
            data: Data,
            type: 'POST',
            dataType: 'json',
            beforeSend: load_in(),
            success: function (data) {
                if(data[0].type === 'error'){
                    notify(data[0].title, data[0].message);
                }else{
                    notify(data[0].title, data[0].message);
                    setTimeOutPage('<?php echo url();?>');
                }
                load_out();
            },
            error: function (request, status, error) {
                notify('Opss', 'Operação não pode ser finalizada!');
            }
        });
        return false;
    }
    function send_cep(){
        let cepN = $(".cep").val();

        let cep = cepN.replace(/\D/g, '');
        if(cep != ""){
            let validacep = /^[0-9]{8}$/;

            if(validacep.test(cep)){
                $.getJSON("https://viacep.com.br/ws/"+ cep +"/json/?callback=?", function(dados) {
                    if (!("erro" in dados)) {
                        $(".rua").val(dados.logradouro);
                        $(".bairro").val(dados.bairro);
                        $(".cidade").val(dados.localidade);
                        $(".uf").val(dados.uf);
                        $(".ibge").val(dados.ibge);
                    }else {
                        notify('Ops', "CEP não encontrado.");
                        empty_cep();
                    }
                });
            }else{
                empty_cep();
                notify('Ops', "CEP inválido");
            }
        }else{
            empty_cep();
            notify('Ops', "CEP inválido");
        }
    }


    function select_empresa(id){
        var acao = "acao=load_empresa&id_contato="+id;
        $.ajax({
            type: 'POST',
            url: "<?= url("select/empresa"); ?>",
            data: acao,
            dataType: 'json',
            beforeSend: load_in(),
            success: function (data_return) {
                var options = '<option value=""></option>';
                for (var i = 0; i < data_return.data.length; i++) {
                    options += '<option value="' + data_return.data[i].certificado_id + '">' + data_return.data[i].certificado_nome + ' - ' + data_return.data[i].certificado_cnpj + '</option>';
                }
                $('.carrega_empresa').html(options).show();
                load_out();
            },
            error: function (request, status, error) {
                var options = '<option value=""></option>';
                $('.carrega_empresa').html(options).show();
            }
        });
        load_out();
    }

    function fazer_bkp(){
        var acao = "acao=fazer_bkp";
        $.ajax({
            type: 'POST',
            url: "<?= url("dump/bkp"); ?>",
            data: acao,
            beforeSend: load_in(),
            dataType: 'json',
            success: function (data) {
                if(data[0].type === 'error'){
                    notify(data[0].title, data[0].message);
                }else{
                    notify(data[0].title, data[0].message);
                }
                load_out();
            },
            error: function (request, status, error) {
                notify('Opss', 'Operação não pode ser finalizada!!');
            }
        });
        load_out();
    }

    $( ".autocomplete_company" ).autocomplete({
        source: function( request, response ) {
            $.ajax({
                url: "<?= url("autocomplete/company"); ?>",
                type: 'post',
                dataType: "json",
                data: {
                    search: request.term
                },
                success: function( data ) {
                    response( data );
                }
            });
        },
        minLength: 2,
        focus: function(event, ui) {
            event.preventDefault();
        },
        select: function( event, ui ) {
            $(".autocomplete_company_id").val(ui.item.value);
            $(".autocomplete_company").val(ui.item.label);
            event.preventDefault();
        }
    });

    $( ".autocomplete_company_completo" ).autocomplete({
        source: function( request, response ) {
            $.ajax({
                url: "<?= url("autocomplete/companyComplete"); ?>",
                type: 'post',
                dataType: "json",
                data: {
                    search: request.term
                },
                success: function( data ) {
                    response( data );
                }
            });
        },
        minLength: 2,
        focus: function(event, ui) {
            event.preventDefault();
        },
        select: function( event, ui ) {
            $(".autocomplete_company_completo_id").val(ui.item.value);
            $(".autocomplete_company_completo").val(ui.item.label);
            event.preventDefault();
        }
    });

    $( ".autocomplete_user" ).autocomplete({
        source: function( request, response ) {
            $.ajax({
                url: "<?= url("autocomplete/user"); ?>",
                type: 'post',
                dataType: "json",
                data: {
                    search: request.term
                },
                success: function( data ) {
                    response( data );
                }
            });
        },
        minLength: 2,
        focus: function(event, ui) {
            event.preventDefault();
        },
        select: function( event, ui ) {
            $(".autocomplete_user_id").val(ui.item.value);
            $(".autocomplete_user").val(ui.item.label);
            event.preventDefault();
        }
    });

    $('.telefone').mask('(00)000000000');
    $('.mask_telefone').mask('(00)000000000');
    $('.referencia_faturamento_mask').mask('00/0000');
    $('.mask_cep').mask('00000-000');
    $('.veiculo_placa').mask('AAA0000');
    $('.cpf').mask('000.000.000-00');
    $('.fipe').mask('000000-0');
    $(".mask_moeda").maskMoney({thousands: '', decimal: '.', allowZero:true});

    $(".mask_moeda_real").maskMoney({thousands: '.', decimal: ','});
    $(".mask_peso").maskMoney({thousands: '', decimal: '.', precision: 3, allowZero:true});
</script>
<?= $v->section("scripts"); ?>
</div>
</body>
</html>
