/*
 Highcharts JS v9.3.3 (2022-02-01)

 (c) 2016-2021 Highsoft AS
 Authors: Jon Arild Nygard

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/sunburst",["highcharts"],function(u){a(u);a.Highcharts=u;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function u(a,g,c,p){a.hasOwnProperty(g)||(a[g]=p.apply(null,c))}a=a?a._modules:{};u(a,"Series/ColorMapMixin.js",[a["Core/Globals.js"],a["Core/Series/Point.js"],a["Core/Utilities.js"]],function(a,g,c){var p=
a.noop;a=a.seriesTypes;var q=c.defined;c=c.addEvent;c(g,"afterSetState",function(a){this.moveToTopOnHover&&this.graphic&&this.graphic.attr({zIndex:a&&"hover"===a.state?1:0})});return{PointMixin:{dataLabelOnNull:!0,moveToTopOnHover:!0,isValid:function(){return null!==this.value&&Infinity!==this.value&&-Infinity!==this.value}},SeriesMixin:{pointArrayMap:["value"],axisTypes:["xAxis","yAxis","colorAxis"],trackerGroups:["group","markerGroup","dataLabelsGroup"],getSymbol:p,parallelArrays:["x","y","value"],
colorKey:"value",pointAttribs:a.column.prototype.pointAttribs,colorAttribs:function(a){var k={};!q(a.color)||a.state&&"normal"!==a.state||(k[this.colorProp||"fill"]=a.color);return k}}}});u(a,"Series/Treemap/TreemapAlgorithmGroup.js",[],function(){return function(){function a(a,c,p,q){this.height=a;this.width=c;this.plot=q;this.startDirection=this.direction=p;this.lH=this.nH=this.lW=this.nW=this.total=0;this.elArr=[];this.lP={total:0,lH:0,nH:0,lW:0,nW:0,nR:0,lR:0,aspectRatio:function(a,d){return Math.max(a/
d,d/a)}}}a.prototype.addElement=function(a){this.lP.total=this.elArr[this.elArr.length-1];this.total+=a;0===this.direction?(this.lW=this.nW,this.lP.lH=this.lP.total/this.lW,this.lP.lR=this.lP.aspectRatio(this.lW,this.lP.lH),this.nW=this.total/this.height,this.lP.nH=this.lP.total/this.nW,this.lP.nR=this.lP.aspectRatio(this.nW,this.lP.nH)):(this.lH=this.nH,this.lP.lW=this.lP.total/this.lH,this.lP.lR=this.lP.aspectRatio(this.lP.lW,this.lH),this.nH=this.total/this.width,this.lP.nW=this.lP.total/this.nH,
this.lP.nR=this.lP.aspectRatio(this.lP.nW,this.nH));this.elArr.push(a)};a.prototype.reset=function(){this.lW=this.nW=0;this.elArr=[];this.total=0};return a}()});u(a,"Series/DrawPointComposition.js",[],function(){var a;(function(a){function c(a){var d=this,l=a.animatableAttribs,n=a.onComplete,b=a.css,e=a.renderer,v=this.series&&this.series.chart.hasRendered?void 0:this.series&&this.series.options.animation,w=this.graphic;a.attribs=a.attribs||{};a.attribs["class"]=this.getClassName();if(this.shouldDraw())w||
(this.graphic=w=e[a.shapeType](a.shapeArgs).add(a.group)),w.css(b).attr(a.attribs).animate(l,a.isNew?!1:v,n);else if(w){var c=function(){d.graphic=w=w&&w.destroy();"function"===typeof n&&n()};Object.keys(l).length?w.animate(l,void 0,function(){c()}):c()}}function g(){return!this.isNull}var q=[];a.compose=function(a){if(-1===q.indexOf(a)){q.push(a);var d=a.prototype;d.draw=c;d.shouldDraw||(d.shouldDraw=g)}return a}})(a||(a={}));return a});u(a,"Series/Treemap/TreemapPoint.js",[a["Series/DrawPointComposition.js"],
a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,g,c){var p=this&&this.__extends||function(){var a=function(b,v){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var e in b)b.hasOwnProperty(e)&&(a[e]=b[e])};return a(b,v)};return function(b,v){function e(){this.constructor=b}a(b,v);b.prototype=null===v?Object.create(v):(e.prototype=v.prototype,new e)}}(),q=g.series.prototype.pointClass,k=g.seriesTypes;g=k.pie.prototype.pointClass;
var d=c.extend,l=c.isNumber,n=c.pick;c=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.name=void 0;b.node=void 0;b.options=void 0;b.series=void 0;b.value=void 0;return b}p(b,a);b.prototype.getClassName=function(){var b=q.prototype.getClassName.call(this),a=this.series,e=a.options;this.node.level<=a.nodeMap[a.rootNode].level?b+=" highcharts-above-level":this.node.isLeaf||n(e.interactByLeaf,!e.allowTraversingTree)?this.node.isLeaf||(b+=" highcharts-internal-node"):b+=" highcharts-internal-node-interactive";
return b};b.prototype.isValid=function(){return!(!this.id&&!l(this.value))};b.prototype.setState=function(b){q.prototype.setState.call(this,b);this.graphic&&this.graphic.attr({zIndex:"hover"===b?1:0})};b.prototype.shouldDraw=function(){return l(this.plotY)&&null!==this.y};return b}(k.scatter.prototype.pointClass);d(c.prototype,{setVisible:g.prototype.setVisible});a.compose(c);return c});u(a,"Series/Treemap/TreemapUtilities.js",[a["Core/Utilities.js"]],function(a){var g=a.objectEach,c;(function(a){function c(a,
d,l){void 0===l&&(l=this);a=d.call(l,a);!1!==a&&c(a,d,l)}a.AXIS_MAX=100;a.isBoolean=function(a){return"boolean"===typeof a};a.eachObject=function(a,c,l){l=l||this;g(a,function(d,b){c.call(l,d,b,a)})};a.recursive=c})(c||(c={}));return c});u(a,"Series/TreeUtilities.js",[a["Core/Color/Color.js"],a["Core/Utilities.js"]],function(a,g){function c(a,e){var b=e.before,d=e.idRoot,l=e.mapIdToNode[d],g=e.points[a.i],q=g&&g.options||{},k=[],B=0;a.levelDynamic=a.level-(!1!==e.levelIsConstant?0:l.level);a.name=
n(g&&g.name,"");a.visible=d===a.id||!0===e.visible;"function"===typeof b&&(a=b(a,e));a.children.forEach(function(b,d){var l=p({},e);p(l,{index:d,siblings:a.children.length,visible:a.visible});b=c(b,l);k.push(b);b.visible&&(B+=b.val)});b=n(q.value,B);a.visible=0<=b&&(0<B||a.visible);a.children=k;a.childrenTotal=B;a.isLeaf=a.visible&&!B;a.val=b;return a}var p=g.extend,q=g.isArray,k=g.isNumber,d=g.isObject,l=g.merge,n=g.pick;return{getColor:function(b,e){var d=e.index,l=e.mapOptionsToLevel,c=e.parentColor,
g=e.parentColorIndex,k=e.series,q=e.colors,B=e.siblings,p=k.points,u=k.chart.options.chart,A;if(b){p=p[b.i];b=l[b.level]||{};if(l=p&&b.colorByPoint){var D=p.index%(q?q.length:u.colorCount);var G=q&&q[D]}if(!k.chart.styledMode){q=p&&p.options.color;u=b&&b.color;if(A=c)A=(A=b&&b.colorVariation)&&"brightness"===A.key&&d&&B?a.parse(c).brighten(d/B*A.to).get():c;A=n(q,u,G,A,k.color)}var E=n(p&&p.options.colorIndex,b&&b.colorIndex,D,g,e.colorIndex)}return{color:A,colorIndex:E}},getLevelOptions:function(a){var b=
null;if(d(a)){b={};var c=k(a.from)?a.from:1;var g=a.levels;var p={};var A=d(a.defaults)?a.defaults:{};q(g)&&(p=g.reduce(function(a,b){if(d(b)&&k(b.level)){var e=l({},b);var g=n(e.levelIsConstant,A.levelIsConstant);delete e.levelIsConstant;delete e.level;b=b.level+(g?0:c-1);d(a[b])?l(!0,a[b],e):a[b]=e}return a},{}));g=k(a.to)?a.to:1;for(a=0;a<=g;a++)b[a]=l({},A,d(p[a])?p[a]:{})}return b},setTreeValues:c,updateRootId:function(a){if(d(a)){var b=d(a.options)?a.options:{};b=n(a.rootNode,b.rootId,"");d(a.userOptions)&&
(a.userOptions.rootId=b);a.rootNode=b}return b}}});u(a,"Series/Treemap/TreemapComposition.js",[a["Core/Series/SeriesRegistry.js"],a["Series/Treemap/TreemapUtilities.js"],a["Core/Utilities.js"]],function(a,g,c){var p=c.addEvent,q=c.extend,k=!1;p(a.series,"afterBindAxes",function(){var a=this.xAxis,c=this.yAxis;if(a&&c)if(this.is("treemap")){var n={endOnTick:!1,gridLineWidth:0,lineWidth:0,min:0,minPadding:0,max:g.AXIS_MAX,maxPadding:0,startOnTick:!1,title:void 0,tickPositions:[]};q(c.options,n);q(a.options,
n);k=!0}else k&&(c.setOptions(c.userOptions),a.setOptions(a.userOptions),k=!1)})});u(a,"Series/Treemap/TreemapSeries.js",[a["Core/Color/Color.js"],a["Series/ColorMapMixin.js"],a["Core/Globals.js"],a["Core/Legend/LegendSymbol.js"],a["Core/Series/SeriesRegistry.js"],a["Series/Treemap/TreemapAlgorithmGroup.js"],a["Series/Treemap/TreemapPoint.js"],a["Series/Treemap/TreemapUtilities.js"],a["Series/TreeUtilities.js"],a["Core/Utilities.js"]],function(a,g,c,p,q,k,d,l,n,b){var e=this&&this.__extends||function(){var a=
function(b,f){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(f,a){f.__proto__=a}||function(f,a){for(var m in a)a.hasOwnProperty(m)&&(f[m]=a[m])};return a(b,f)};return function(b,f){function m(){this.constructor=b}a(b,f);b.prototype=null===f?Object.create(f):(m.prototype=f.prototype,new m)}}(),v=a.parse;a=c.noop;var w=q.series;c=q.seriesTypes;var Q=c.column,A=c.heatmap,u=c.scatter,K=n.getColor,B=n.getLevelOptions,L=n.updateRootId,H=b.addEvent,I=b.correctFloat,D=b.defined,G=b.error,
E=b.extend,M=b.fireEvent,J=b.isArray,T=b.isObject,N=b.isString,h=b.merge,t=b.pick,F=b.stableSort;n=function(a){function b(){var f=null!==a&&a.apply(this,arguments)||this;f.axisRatio=void 0;f.data=void 0;f.mapOptionsToLevel=void 0;f.nodeMap=void 0;f.options=void 0;f.points=void 0;f.rootNode=void 0;f.tree=void 0;return f}e(b,a);b.prototype.algorithmCalcPoints=function(f,a,b,h){var m,C,r,e,c=b.lW,y=b.lH,d=b.plot,l=0,g=b.elArr.length-1;if(a)c=b.nW,y=b.nH;else var t=b.elArr[b.elArr.length-1];b.elArr.forEach(function(f){if(a||
l<g)0===b.direction?(m=d.x,C=d.y,r=c,e=f/r):(m=d.x,C=d.y,e=y,r=f/e),h.push({x:m,y:C,width:r,height:I(e)}),0===b.direction?d.y+=e:d.x+=r;l+=1});b.reset();0===b.direction?b.width-=c:b.height-=y;d.y=d.parent.y+(d.parent.height-b.height);d.x=d.parent.x+(d.parent.width-b.width);f&&(b.direction=1-b.direction);a||b.addElement(t)};b.prototype.algorithmFill=function(f,a,b){var m=[],h,r=a.direction,e=a.x,d=a.y,c=a.width,y=a.height,l,g,t,n;b.forEach(function(b){h=b.val/a.val*a.height*a.width;l=e;g=d;0===r?(n=
y,t=h/n,c-=t,e+=t):(t=c,n=h/t,y-=n,d+=n);m.push({x:l,y:g,width:t,height:n});f&&(r=1-r)});return m};b.prototype.algorithmLowAspectRatio=function(a,b,h){var f=[],m=this,r,e={x:b.x,y:b.y,parent:b},d=0,c=h.length-1,y=new k(b.height,b.width,b.direction,e);h.forEach(function(h){r=h.val/b.val*b.height*b.width;y.addElement(r);y.lP.nR>y.lP.lR&&m.algorithmCalcPoints(a,!1,y,f,e);d===c&&m.algorithmCalcPoints(a,!0,y,f,e);d+=1});return f};b.prototype.alignDataLabel=function(a,b,h){var f=h.style;f&&!D(f.textOverflow)&&
b.text&&b.getBBox().width>b.text.textWidth&&b.css({textOverflow:"ellipsis",width:f.width+="px"});Q.prototype.alignDataLabel.apply(this,arguments);a.dataLabel&&a.dataLabel.attr({zIndex:(a.node.zIndex||0)+1})};b.prototype.buildNode=function(a,b,h,e,x){var f=this,m=[],r=f.points[b],C=0,d;(e[a]||[]).forEach(function(b){d=f.buildNode(f.points[b].id,b,h+1,e,a);C=Math.max(d.height+1,C);m.push(d)});b={id:a,i:b,children:m,height:C,level:h,parent:x,visible:!1};f.nodeMap[b.id]=b;r&&(r.node=b);return b};b.prototype.calculateChildrenAreas=
function(a,b){var f=this,m=f.options,x=f.mapOptionsToLevel[a.level+1],e=t(f[x&&x.layoutAlgorithm]&&x.layoutAlgorithm,m.layoutAlgorithm),d=m.alternateStartingDirection,c=[];a=a.children.filter(function(a){return!a.ignore});x&&x.layoutStartingDirection&&(b.direction="vertical"===x.layoutStartingDirection?0:1);c=f[e](b,a);a.forEach(function(a,m){m=c[m];a.values=h(m,{val:a.childrenTotal,direction:d?1-b.direction:b.direction});a.pointValues=h(m,{x:m.x/f.axisRatio,y:l.AXIS_MAX-m.y-m.height,width:m.width/
f.axisRatio});a.children.length&&f.calculateChildrenAreas(a,a.values)})};b.prototype.drawDataLabels=function(){var a=this,b=a.mapOptionsToLevel,e,d;a.points.filter(function(a){return a.node.visible}).forEach(function(f){d=b[f.node.level];e={style:{}};f.node.isLeaf||(e.enabled=!1);d&&d.dataLabels&&(e=h(e,d.dataLabels),a._hasPointLabels=!0);f.shapeArgs&&(e.style.width=f.shapeArgs.width,f.dataLabel&&f.dataLabel.css({width:f.shapeArgs.width+"px"}));f.dlOptions=h(e,f.options.dataLabels)});w.prototype.drawDataLabels.call(this)};
b.prototype.drawPoints=function(){var a=this,b=a.chart,e=b.renderer,d=b.styledMode,c=a.options,l=d?{}:c.shadow,g=c.borderRadius,t=b.pointCount<c.animationLimit,n=c.allowTraversingTree;a.points.forEach(function(b){var f=b.node.levelDynamic,m={},r={},C={},x="level-group-"+b.node.level,O=!!b.graphic,U=t&&O,P=b.shapeArgs;b.shouldDraw()&&(b.isInside=!0,g&&(r.r=g),h(!0,U?m:r,O?P:{},d?{}:a.pointAttribs(b,b.selected?"select":void 0)),a.colorAttribs&&d&&E(C,a.colorAttribs(b)),a[x]||(a[x]=e.g(x).attr({zIndex:1E3-
(f||0)}).add(a.group),a[x].survive=!0));b.draw({animatableAttribs:m,attribs:r,css:C,group:a[x],renderer:e,shadow:l,shapeArgs:P,shapeType:"rect"});n&&b.graphic&&(b.drillId=c.interactByLeaf?a.drillToByLeaf(b):a.drillToByGroup(b))})};b.prototype.drillToByGroup=function(a){var b=!1;1!==a.node.level-this.nodeMap[this.rootNode].level||a.node.isLeaf||(b=a.id);return b};b.prototype.drillToByLeaf=function(a){var b=!1;if(a.node.parent!==this.rootNode&&a.node.isLeaf)for(a=a.node;!b;)a=this.nodeMap[a.parent],
a.parent===this.rootNode&&(b=a.id);return b};b.prototype.drillToNode=function(a,b){G(32,!1,void 0,{"treemap.drillToNode":"use treemap.setRootNode"});this.setRootNode(a,b)};b.prototype.drillUp=function(){var a=this.nodeMap[this.rootNode];a&&N(a.parent)&&this.setRootNode(a.parent,!0,{trigger:"traverseUpButton"})};b.prototype.getExtremes=function(){var a=w.prototype.getExtremes.call(this,this.colorValueData),b=a.dataMax;this.valueMin=a.dataMin;this.valueMax=b;return w.prototype.getExtremes.call(this)};
b.prototype.getListOfParents=function(a,b){a=J(a)?a:[];var f=J(b)?b:[];b=a.reduce(function(a,b,f){b=t(b.parent,"");"undefined"===typeof a[b]&&(a[b]=[]);a[b].push(f);return a},{"":[]});l.eachObject(b,function(a,b,m){""!==b&&-1===f.indexOf(b)&&(a.forEach(function(a){m[""].push(a)}),delete m[b])});return b};b.prototype.getTree=function(){var a=this.data.map(function(a){return a.id});a=this.getListOfParents(this.data,a);this.nodeMap={};return this.buildNode("",-1,0,a)};b.prototype.hasData=function(){return!!this.processedXData.length};
b.prototype.init=function(a,b){this.colorAttribs=g.SeriesMixin.colorAttribs;var f=H(this,"setOptions",function(a){a=a.userOptions;D(a.allowDrillToNode)&&!D(a.allowTraversingTree)&&(a.allowTraversingTree=a.allowDrillToNode,delete a.allowDrillToNode);D(a.drillUpButton)&&!D(a.traverseUpButton)&&(a.traverseUpButton=a.drillUpButton,delete a.drillUpButton)});w.prototype.init.call(this,a,b);delete this.opacity;this.eventsToUnbind.push(f);this.options.allowTraversingTree&&this.eventsToUnbind.push(H(this,
"click",this.onClickDrillToNode))};b.prototype.onClickDrillToNode=function(a){var b=(a=a.point)&&a.drillId;N(b)&&(a.setState(""),this.setRootNode(b,!0,{trigger:"click"}))};b.prototype.pointAttribs=function(a,b){var f=T(this.mapOptionsToLevel)?this.mapOptionsToLevel:{},m=a&&f[a.node.level]||{};f=this.options;var h=b&&f.states[b]||{},e=a&&a.getClassName()||"";a={stroke:a&&a.borderColor||m.borderColor||h.borderColor||f.borderColor,"stroke-width":t(a&&a.borderWidth,m.borderWidth,h.borderWidth,f.borderWidth),
dashstyle:a&&a.borderDashStyle||m.borderDashStyle||h.borderDashStyle||f.borderDashStyle,fill:a&&a.color||this.color};-1!==e.indexOf("highcharts-above-level")?(a.fill="none",a["stroke-width"]=0):-1!==e.indexOf("highcharts-internal-node-interactive")?(b=t(h.opacity,f.opacity),a.fill=v(a.fill).setOpacity(b).get(),a.cursor="pointer"):-1!==e.indexOf("highcharts-internal-node")?a.fill="none":b&&(a.fill=v(a.fill).brighten(h.brightness).get());return a};b.prototype.renderTraverseUpButton=function(a){var b=
this,f=b.options.traverseUpButton,h=t(f.text,b.nodeMap[a].name,"\u25c1 Back");if(""===a||b.is("sunburst")&&1===b.tree.children.length&&a===b.tree.children[0].id)b.drillUpButton&&(b.drillUpButton=b.drillUpButton.destroy());else if(this.drillUpButton)this.drillUpButton.placed=!1,this.drillUpButton.attr({text:h}).align();else{var e=(a=f.theme)&&a.states;this.drillUpButton=this.chart.renderer.button(h,0,0,function(){b.drillUp()},a,e&&e.hover,e&&e.select).addClass("highcharts-drillup-button").attr({align:f.position.align,
zIndex:7}).add().align(f.position,!1,f.relativeTo||"plotBox")}};b.prototype.setColorRecursive=function(a,b,h,e,d){var f=this,m=f&&f.chart;m=m&&m.options&&m.options.colors;if(a){var c=K(a,{colors:m,index:e,mapOptionsToLevel:f.mapOptionsToLevel,parentColor:b,parentColorIndex:h,series:f,siblings:d});if(b=f.points[a.i])b.color=c.color,b.colorIndex=c.colorIndex;(a.children||[]).forEach(function(b,h){f.setColorRecursive(b,c.color,c.colorIndex,h,a.children.length)})}};b.prototype.setPointValues=function(){var a=
this,b=a.xAxis,h=a.yAxis,e=a.chart.styledMode;a.points.forEach(function(f){var m=f.node,d=m.pointValues;m=m.visible;if(d&&m){m=d.height;var c=d.width,l=d.x,g=d.y,t=e?0:(a.pointAttribs(f)["stroke-width"]||0)%2/2;d=Math.round(b.toPixels(l,!0))-t;c=Math.round(b.toPixels(l+c,!0))-t;l=Math.round(h.toPixels(g,!0))-t;m=Math.round(h.toPixels(g+m,!0))-t;m={x:Math.min(d,c),y:Math.min(l,m),width:Math.abs(c-d),height:Math.abs(m-l)};f.plotX=m.x+m.width/2;f.plotY=m.y+m.height/2;f.shapeArgs=m}else delete f.plotX,
delete f.plotY})};b.prototype.setRootNode=function(a,b,h){a=E({newRootId:a,previousRootId:this.rootNode,redraw:t(b,!0),series:this},h);M(this,"setRootNode",a,function(a){var b=a.series;b.idPreviousRoot=a.previousRootId;b.rootNode=a.newRootId;b.isDirty=!0;a.redraw&&b.chart.redraw()})};b.prototype.setState=function(a){this.options.inactiveOtherPoints=!0;w.prototype.setState.call(this,a,!1);this.options.inactiveOtherPoints=!1};b.prototype.setTreeValues=function(a){var b=this,f=b.options,h=b.nodeMap[b.rootNode];
f=l.isBoolean(f.levelIsConstant)?f.levelIsConstant:!0;var e=0,d=[],c=b.points[a.i];a.children.forEach(function(a){a=b.setTreeValues(a);d.push(a);a.ignore||(e+=a.val)});F(d,function(a,b){return(a.sortIndex||0)-(b.sortIndex||0)});var g=t(c&&c.options.value,e);c&&(c.value=g);E(a,{children:d,childrenTotal:e,ignore:!(t(c&&c.visible,!0)&&0<g),isLeaf:a.visible&&!e,levelDynamic:a.level-(f?0:h.level),name:t(c&&c.name,""),sortIndex:t(c&&c.sortIndex,-g),val:g});return a};b.prototype.sliceAndDice=function(a,
b){return this.algorithmFill(!0,a,b)};b.prototype.squarified=function(a,b){return this.algorithmLowAspectRatio(!0,a,b)};b.prototype.strip=function(a,b){return this.algorithmLowAspectRatio(!1,a,b)};b.prototype.stripes=function(a,b){return this.algorithmFill(!1,a,b)};b.prototype.translate=function(){var a=this,b=a.options,e=L(a);w.prototype.translate.call(a);var d=a.tree=a.getTree();var c=a.nodeMap[e];""===e||c&&c.children.length||(a.setRootNode("",!1),e=a.rootNode,c=a.nodeMap[e]);a.renderTraverseUpButton(e);
a.mapOptionsToLevel=B({from:c.level+1,levels:b.levels,to:d.height,defaults:{levelIsConstant:a.options.levelIsConstant,colorByPoint:b.colorByPoint}});l.recursive(a.nodeMap[a.rootNode],function(b){var h=!1,f=b.parent;b.visible=!0;if(f||""===f)h=a.nodeMap[f];return h});l.recursive(a.nodeMap[a.rootNode].children,function(a){var b=!1;a.forEach(function(a){a.visible=!0;a.children.length&&(b=(b||[]).concat(a.children))});return b});a.setTreeValues(d);a.axisRatio=a.xAxis.len/a.yAxis.len;a.nodeMap[""].pointValues=
e={x:0,y:0,width:l.AXIS_MAX,height:l.AXIS_MAX};a.nodeMap[""].values=e=h(e,{width:e.width*a.axisRatio,direction:"vertical"===b.layoutStartingDirection?0:1,val:d.val});a.calculateChildrenAreas(d,e);a.colorAxis||b.colorByPoint||a.setColorRecursive(a.tree);b.allowTraversingTree&&(b=c.pointValues,a.xAxis.setExtremes(b.x,b.x+b.width,!1),a.yAxis.setExtremes(b.y,b.y+b.height,!1),a.xAxis.setScale(),a.yAxis.setScale());a.setPointValues()};b.defaultOptions=h(u.defaultOptions,{allowTraversingTree:!1,animationLimit:250,
borderRadius:0,showInLegend:!1,marker:void 0,colorByPoint:!1,dataLabels:{defer:!1,enabled:!0,formatter:function(){var a=this&&this.point?this.point:{};return N(a.name)?a.name:""},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:"",pointFormat:"<b>{point.name}</b>: {point.value}<br/>"},ignoreHiddenPoint:!0,layoutAlgorithm:"sliceAndDice",layoutStartingDirection:"vertical",alternateStartingDirection:!1,levelIsConstant:!0,drillUpButton:{position:{align:"right",x:-10,y:10}},traverseUpButton:{position:{align:"right",
x:-10,y:10}},borderColor:"#e6e6e6",borderWidth:1,colorKey:"colorValue",opacity:.15,states:{hover:{borderColor:"#999999",brightness:A?0:.1,halo:!1,opacity:.75,shadow:!1}}});return b}(u);E(n.prototype,{buildKDTree:a,colorKey:"colorValue",directTouch:!0,drawLegendSymbol:p.drawRectangle,getExtremesFromAll:!0,getSymbol:a,optionalAxis:"colorAxis",parallelArrays:["x","y","value","colorValue"],pointArrayMap:["value"],pointClass:d,trackerGroups:["group","dataLabelsGroup"],utils:{recursive:l.recursive}});q.registerSeriesType("treemap",
n);"";return n});u(a,"Series/Sunburst/SunburstPoint.js",[a["Series/DrawPointComposition.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,g,c){var p=this&&this.__extends||function(){var a=function(c,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,e){a.__proto__=e}||function(a,e){for(var b in e)e.hasOwnProperty(b)&&(a[b]=e[b])};return a(c,d)};return function(c,d){function b(){this.constructor=c}a(c,d);c.prototype=null===d?Object.create(d):(b.prototype=
d.prototype,new b)}}(),q=g.series.prototype.pointClass,k=c.correctFloat;c=c.extend;g=function(a){function c(){var c=null!==a&&a.apply(this,arguments)||this;c.node=void 0;c.options=void 0;c.series=void 0;c.shapeExisting=void 0;return c}p(c,a);c.prototype.getDataLabelPath=function(a){var b=this.series.chart.renderer,e=this.shapeExisting,c=e.start,d=e.end,g=c+(d-c)/2;g=0>g&&g>-Math.PI||g>Math.PI;var l=e.r+(a.options.distance||0);c===-Math.PI/2&&k(d)===k(1.5*Math.PI)&&(c=-Math.PI+Math.PI/360,d=-Math.PI/
360,g=!0);if(d-c>Math.PI){g=!1;var q=!0}this.dataLabelPath&&(this.dataLabelPath=this.dataLabelPath.destroy());this.dataLabelPath=b.arc({open:!0,longArc:q?1:0}).add(a);this.dataLabelPath.attr({start:g?c:d,end:g?d:c,clockwise:+g,x:e.x,y:e.y,r:(l+e.innerR)/2});return this.dataLabelPath};c.prototype.isValid=function(){return!0};return c}(g.seriesTypes.treemap.prototype.pointClass);c(g.prototype,{getClassName:q.prototype.getClassName,haloPath:q.prototype.haloPath,setState:q.prototype.setState});a.compose(g);
return g});u(a,"Series/Sunburst/SunburstUtilities.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,g){var c=a.seriesTypes.treemap,p=g.isNumber,q=g.isObject,k=g.merge,d;(function(a){function d(a,c){var b=[];if(p(a)&&p(c)&&a<=c)for(;a<=c;a++)b.push(a);return b}a.recursive=c.prototype.utils.recursive;a.calculateLevelSizes=function(a,c){c=q(c)?c:{};var b=0,e;if(q(a)){var g=k({},a);a=p(c.from)?c.from:0;var l=p(c.to)?c.to:0;var n=d(a,l);a=Object.keys(g).filter(function(a){return-1===
n.indexOf(+a)});var u=e=p(c.diffRadius)?c.diffRadius:0;n.forEach(function(a){a=g[a];var c=a.levelSize.unit,d=a.levelSize.value;"weight"===c?b+=d:"percentage"===c?(a.levelSize={unit:"pixels",value:d/100*u},e-=a.levelSize.value):"pixels"===c&&(e-=d)});n.forEach(function(a){var c=g[a];"weight"===c.levelSize.unit&&(c=c.levelSize.value,g[a].levelSize={unit:"pixels",value:c/b*e})});a.forEach(function(a){g[a].levelSize={value:0,unit:"pixels"}})}return g};a.getLevelFromAndTo=function(a){var b=a.level;return{from:0<
b?b:1,to:b+a.height}};a.range=d})(d||(d={}));return d});u(a,"Series/Sunburst/SunburstSeries.js",[a["Series/CenteredUtilities.js"],a["Core/Globals.js"],a["Core/Series/SeriesRegistry.js"],a["Series/Sunburst/SunburstPoint.js"],a["Series/Sunburst/SunburstUtilities.js"],a["Series/TreeUtilities.js"],a["Core/Utilities.js"]],function(a,g,c,p,q,k,d){function l(a,b){var c=b.mapIdToNode[a.parent],d=b.series,e=d.chart,g=d.points[a.i];c=R(a,{colors:d.options.colors||e&&e.options.colors,colorIndex:d.colorIndex,
index:b.index,mapOptionsToLevel:b.mapOptionsToLevel,parentColor:c&&c.color,parentColorIndex:c&&c.colorIndex,series:b.series,siblings:b.siblings});a.color=c.color;a.colorIndex=c.colorIndex;g&&(g.color=a.color,g.colorIndex=a.colorIndex,a.sliced=a.id!==b.idRoot?g.sliced:!1);return a}var n=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,
c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),b=a.getCenter,e=a.getStartAndEndRadians;a=g.noop;var u=c.series,w=c.seriesTypes;g=w.column;var A=w.treemap,R=k.getColor,S=k.getLevelOptions,K=k.setTreeValues,B=k.updateRootId,L=d.error,H=d.extend,I=d.isNumber,D=d.isObject,G=d.isString,E=d.merge,M=d.splat,J=180/Math.PI;k=function(a){function c(){var b=null!==a&&a.apply(this,arguments)||this;b.center=void 0;b.data=
void 0;b.mapOptionsToLevel=void 0;b.nodeMap=void 0;b.options=void 0;b.points=void 0;b.shapeRoot=void 0;b.startAndEndRadians=void 0;b.tree=void 0;return b}n(c,a);c.prototype.alignDataLabel=function(b,c,d){if(!d.textPath||!d.textPath.enabled)return a.prototype.alignDataLabel.apply(this,arguments)};c.prototype.animate=function(a){var b=this.chart,c=[b.plotWidth/2,b.plotHeight/2],d=b.plotLeft,e=b.plotTop;b=this.group;a?(a={translateX:c[0]+d,translateY:c[1]+e,scaleX:.001,scaleY:.001,rotation:10,opacity:.01},
b.attr(a)):(a={translateX:d,translateY:e,scaleX:1,scaleY:1,rotation:0,opacity:1},b.animate(a,this.options.animation))};c.prototype.drawPoints=function(){var a=this,b=a.mapOptionsToLevel,c=a.shapeRoot,d=a.group,e=a.hasRendered,f=a.rootNode,m=a.idPreviousRoot,g=a.nodeMap,l=g[m],q=l&&l.shapeArgs;l=a.points;var n=a.startAndEndRadians,p=a.chart,k=p&&p.options&&p.options.chart||{},w="boolean"===typeof k.animation?k.animation:!0,y=a.center[3]/2,A=a.chart.renderer,B=!1,v=!1;if(k=!!(w&&e&&f!==m&&a.dataLabelsGroup)){a.dataLabelsGroup.attr({opacity:0});
var G=function(){B=!0;a.dataLabelsGroup&&a.dataLabelsGroup.animate({opacity:1,visibility:"visible"})}}l.forEach(function(h){var l=h.node,k=b[l.level];var t=h.shapeExisting||{};var r=l.shapeArgs||{},u=!(!l.visible||!l.shapeArgs);if(e&&w){var C={};var x={end:r.end,start:r.start,innerR:r.innerR,r:r.r,x:r.x,y:r.y};u?!h.graphic&&q&&(C=f===h.id?{start:n.start,end:n.end}:q.end<=r.start?{start:n.end,end:n.end}:{start:n.start,end:n.start},C.innerR=C.r=y):h.graphic&&(m===h.id?x={innerR:y,r:y}:c&&(x=c.end<=
t.start?{innerR:y,r:y,start:n.end,end:n.end}:{innerR:y,r:y,start:n.start,end:n.start}));t=C}else x=r,t={};C=[r.plotX,r.plotY];if(!h.node.isLeaf)if(f===h.id){var z=g[f];z=z.parent}else z=h.id;H(h,{shapeExisting:r,tooltipPos:C,drillId:z,name:""+(h.name||h.id||h.index),plotX:r.plotX,plotY:r.plotY,value:l.val,isInside:u,isNull:!u});z=h.options;l=D(r)?r:{};z=D(z)?z.dataLabels:{};k=M(D(k)?k.dataLabels:{})[0];k=E({style:{}},k,z);z=k.rotationMode;if(!I(k.rotation)){if("auto"===z||"circular"===z)if(1>h.innerArcLength&&
h.outerArcLength>l.radius){var F=0;h.dataLabelPath&&"circular"===z&&(k.textPath={enabled:!0})}else 1<h.innerArcLength&&h.outerArcLength>1.5*l.radius?"circular"===z?k.textPath={enabled:!0,attributes:{dy:5}}:z="parallel":(h.dataLabel&&h.dataLabel.textPathWrapper&&"circular"===z&&(k.textPath={enabled:!1}),z="perpendicular");"auto"!==z&&"circular"!==z&&(F=l.end-(l.end-l.start)/2);k.style.width="parallel"===z?Math.min(2.5*l.radius,(h.outerArcLength+h.innerArcLength)/2):l.radius;"perpendicular"===z&&h.series.chart.renderer.fontMetrics(k.style.fontSize).h>
h.outerArcLength&&(k.style.width=1);k.style.width=Math.max(k.style.width-2*(k.padding||0),1);F=F*J%180;"parallel"===z&&(F-=90);90<F?F-=180:-90>F&&(F+=180);k.rotation=F}k.textPath&&(0===h.shapeExisting.innerR&&k.textPath.enabled?(k.rotation=0,k.textPath.enabled=!1,k.style.width=Math.max(2*h.shapeExisting.r-2*(k.padding||0),1)):h.dlOptions&&h.dlOptions.textPath&&!h.dlOptions.textPath.enabled&&"circular"===z&&(k.textPath.enabled=!0),k.textPath.enabled&&(k.rotation=0,k.style.width=Math.max((h.outerArcLength+
h.innerArcLength)/2-2*(k.padding||0),1)));0===k.rotation&&(k.rotation=.001);h.dlOptions=k;if(!v&&u){v=!0;var B=G}h.draw({animatableAttribs:x,attribs:H(t,!p.styledMode&&a.pointAttribs(h,h.selected&&"select")),onComplete:B,group:d,renderer:A,shapeType:"arc",shapeArgs:r})});k&&v?(a.hasRendered=!1,a.options.dataLabels.defer=!0,u.prototype.drawDataLabels.call(a),a.hasRendered=!0,B&&G()):u.prototype.drawDataLabels.call(a)};c.prototype.layoutAlgorithm=function(a,b,c){var d=a.start,e=a.end-d,f=a.val,h=a.x,
g=a.y,l=c&&D(c.levelSize)&&I(c.levelSize.value)?c.levelSize.value:0,k=a.r,n=k+l,t=c&&I(c.slicedOffset)?c.slicedOffset:0;return(b||[]).reduce(function(a,b){var c=1/f*b.val*e,m=d+c/2,r=h+Math.cos(m)*t;m=g+Math.sin(m)*t;b={x:b.sliced?r:h,y:b.sliced?m:g,innerR:k,r:n,radius:l,start:d,end:d+c};a.push(b);d=b.end;return a},[])};c.prototype.setShapeArgs=function(a,b,c){var d=[],e=c[a.level+1];a=a.children.filter(function(a){return a.visible});d=this.layoutAlgorithm(b,a,e);a.forEach(function(a,b){b=d[b];var e=
b.start+(b.end-b.start)/2,f=b.innerR+(b.r-b.innerR)/2,h=b.end-b.start;f=0===b.innerR&&6.28<h?{x:b.x,y:b.y}:{x:b.x+Math.cos(e)*f,y:b.y+Math.sin(e)*f};var g=a.val?a.childrenTotal>a.val?a.childrenTotal:a.val:a.childrenTotal;this.points[a.i]&&(this.points[a.i].innerArcLength=h*b.innerR,this.points[a.i].outerArcLength=h*b.r);a.shapeArgs=E(b,{plotX:f.x,plotY:f.y+4*Math.abs(Math.cos(e))});a.values=E(b,{val:g});a.children.length&&this.setShapeArgs(a,a.values,c)},this)};c.prototype.translate=function(){var a=
this,c=a.options,d=a.center=b.call(a),g=a.startAndEndRadians=e(c.startAngle,c.endAngle),k=d[3]/2,f=d[2]/2-k,m=B(a),n=a.nodeMap,p=n&&n[m],x={};a.shapeRoot=p&&p.shapeArgs;u.prototype.translate.call(a);var w=a.tree=a.getTree();a.renderTraverseUpButton(m);n=a.nodeMap;p=n[m];var A=G(p.parent)?p.parent:"";A=n[A];var v=q.getLevelFromAndTo(p);var D=v.from,y=v.to;v=S({from:D,levels:a.options.levels,to:y,defaults:{colorByPoint:c.colorByPoint,dataLabels:c.dataLabels,levelIsConstant:c.levelIsConstant,levelSize:c.levelSize,
slicedOffset:c.slicedOffset}});v=q.calculateLevelSizes(v,{diffRadius:f,from:D,to:y});K(w,{before:l,idRoot:m,levelIsConstant:c.levelIsConstant,mapOptionsToLevel:v,mapIdToNode:n,points:a.points,series:a});c=n[""].shapeArgs={end:g.end,r:k,start:g.start,val:p.val,x:d[0],y:d[1]};this.setShapeArgs(A,c,v);a.mapOptionsToLevel=v;a.data.forEach(function(b){x[b.id]&&L(31,!1,a.chart);x[b.id]=!0});x={}};c.defaultOptions=E(A.defaultOptions,{center:["50%","50%"],colorByPoint:!1,opacity:1,dataLabels:{allowOverlap:!0,
defer:!0,rotationMode:"auto",style:{textOverflow:"ellipsis"}},rootId:void 0,levelIsConstant:!0,levelSize:{value:1,unit:"weight"},slicedOffset:10});return c}(A);H(k.prototype,{drawDataLabels:a,pointAttribs:g.prototype.pointAttribs,pointClass:p,utils:q});c.registerSeriesType("sunburst",k);"";return k});u(a,"masters/modules/sunburst.src.js",[],function(){})});
//# sourceMappingURL=sunburst.js.map