<?php

namespace Source\Models;
use Source\Conn\DataLayer;

/**
 *
 */
class Sped extends DataLayer
{
    /**
     * @param array $forms
     * @return void
     */
    public function insert(array $forms)
    {

        if($forms['sped_arquivo_id_company'] == '' || $forms['sped_arquivo_referencia'] == ''){
            $this->call(
                '200',
                'Ops',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "error",
                "Email e Razão Social precisam ser preenchidos"
            )->back(["count" => 0]);
            return;
        }

        $result = $this->db()->from('sped_arquivo')
            ->where('sped_arquivo_id_company')->is($forms['sped_arquivo_id_company'])
            ->andWhere('sped_arquivo_id_user')->is(ID_LOG)
            ->andWhere('sped_arquivo_referencia')->is($forms['sped_arquivo_referencia'])
            ->select()
            ->all();

        if($result){
            $this->call(
                '200',
                'Ops',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "error",
                "Você já tem um sped lançado para esse empresa com a mesma referência"
            )->back(["count" => 0]);
            return;
        }

        $contribuicao = $_FILES['contribuicao'];
        $fiscal = $_FILES['fiscal'];

        if(empty($contribuicao)){
            $this->call(
                '200',
                'Ops',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "error",
                "É necessário subir o SPED Contribuição"
            )->back(["count" => 0]);
            return;
        }

        if(empty($fiscal)){
            $this->call(
                '200',
                'Ops',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "error",
                "É necessário subir o SPED Fiscal"
            )->back(["count" => 0]);
            return;
        }


        $nameArquivoContribuicao = md5(date('Y-m-dH:i:s').rand(100,999));
        $nameArquivoFiscal = md5(date('Y-m-dH:i:s').rand(100,999));

        $extencaoContribuicao = explode(".", $contribuicao["name"]);
        $extencaoFiscal = explode(".", $fiscal["name"]);

        $randFolder = ID_LOG.'-'.rand(100000,999999);

        if($extencaoContribuicao['1'] != 'txt' || $extencaoFiscal['1'] != 'txt'){
            $this->call(
                '200',
                'Ops',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "error",
                "Só aceitamos extenções TXT"
            )->back(["count" => 0]);
            return;
        }
        if(mkdir('shared/sped/'.$randFolder.'/', 0777, true)){

        }



        if(move_uploaded_file($contribuicao['tmp_name'], 'shared/sped/'.$randFolder.'/'. $nameArquivoContribuicao.'.txt')){

        }

        if(move_uploaded_file($fiscal['tmp_name'], 'shared/sped/'.$randFolder.'/'. $nameArquivoFiscal.'.txt')){

        }


        $forms_sped['sped_arquivo_lixeira'] = '0';
        $forms_sped['sped_arquivo_id_user'] = ID_LOG;
        $forms_sped['sped_arquivo_referencia'] = $forms['sped_arquivo_referencia'];
        $forms_sped['sped_arquivo_id_company'] = $forms['sped_arquivo_id_company'];
        $forms_sped['sped_arquivo_fiscal'] = 'shared/sped/'.$randFolder.'/'.$nameArquivoFiscal.'.txt';
        $forms_sped['sped_arquivo_contribuicoes'] = 'shared/sped/'.$randFolder.'/'.$nameArquivoContribuicao.'.txt';



        if($this->db()->insert($forms_sped)->into('sped_arquivo')){
            $this->call(
                '200',
                'Parabéns',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "ok",
                "Operação realizada com sucesso."
            )->back(["count" => 0]);
            return;
        }

        $this->call(
            '200',
            'Ops',
            '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
            "error",
            "Houve um problema no processamento da solicitação."
        )->back(["count" => 0]);
        return;
    }

    /**
     * @param array $forms
     * @return void
     */
    public function edit(array $forms)
    {
        $id = $forms['id'];
        unset($forms['id']);

        $result = $this->db()->update('company')->where('company_id')->is($id)->andWhere('company_id_user')->is(ID_LOG)->set($forms);

        if($result == '0' || $result == '1'){
            $this->call(
                '200',
                'Parabéns',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "ok",
                "Operação realizada com sucesso."
            )->back(["count" => 0]);
            return;
        }

        $this->call(
            '200',
            'Ops',
            '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
            "error",
            "Houve um problema no processamento da solicitação."
        )->back(["count" => 0]);
        return;
    }

    /**
     * @param array $data
     * @return void
     */
    public function select(array $data): void
    {
        $start = ($data['pageNo'] * $data['size']) - $data['size'];
        if (empty($data['size'])){
            $max = '300';
        }else{
            $max = $data['size'];
        }

        $forms = $_SESSION[$data['action']]['info'];


        $queryPaginator = $this->db()->from('sped_arquivo')->join('company', function($join){
            $join->on('company_id', 'sped_arquivo_id_company');
        })->where('sped_arquivo_lixeira')->is(0)->andWhere('sped_arquivo_id_user')->is(ID_LOG);

        $query = $this->db()->from('sped_arquivo')->join('company', function($join){
            $join->on('company_id', 'sped_arquivo_id_company');
        })->where('sped_arquivo_lixeira')->is(0)->andWhere('sped_arquivo_id_user')->is(ID_LOG);




        if($forms['id_empresa'] != ''){
            $queryPaginator = $queryPaginator->andWhere('sped_arquivo_id_company')->is($forms['id_empresa']);
            $query = $query->andWhere('sped_arquivo_id_company')->is($forms['id_empresa']);
        }
        if($forms['referencia'] != ''){
            $queryPaginator = $queryPaginator->andWhere('sped_arquivo_referencia')->is($forms['referencia']);
            $query = $query->andWhere('sped_arquivo_referencia')->is($forms['referencia']);
        }

        $resPaginator = $queryPaginator->select()->all();
        $result = $query->orderBy('sped_arquivo_id', 'desc')
            //->limit($data['size'])
            //->offset($start)
            ->select()
            ->all();


        if($result){
            $page = ceil(count($resPaginator) / $max);
            $rows['last_page'] = $page;
            $rows['quantify'] = count($resPaginator);
            $retorno = '';
            foreach($result as $r){
                $retorno .= '<div class="col-sm-3">
                    <div class="box box-color green box-small box-bordered">
                        <div class="box-title">
                            <h3>
                                <i class="fa fa-archive"></i>
                                '.substr($r->company_name,0,30).' - '.$r->sped_arquivo_referencia.'
                            </h3>
                        </div>
                        <div class="box-content" align="center">
                            <a href="view/'.$r->sped_arquivo_id.'" class="btn btn-success">VER</a>
                            <a href="#" class="btn btn-danger">DELETAR</a>
                        </div>
                    </div>
                </div>';
            }
            $rows['type'] = 'ok';
            $rows['retorno'] = $retorno;

            echo json_encode($rows);
            return;
        }else{
            $rows['last_page'] = '0';
            $rows['quantify'] = '0';
            echo json_encode($rows);
            return;
        }
    }

    /**
     * @param array $data
     * @return void
     */
    public function selectId(array $data): void
    {
        $result = $this->db()->from('company')
            ->where('company_id')->is($data['id'])
            ->andWhere('company_id_user')->is(ID_LOG)
            ->select()
            ->all();

        if($result){
            foreach ($result as $r){
                echo json_encode($r);
            }
            return;
        }
    }

    /**
     * @param array $data
     * @return void
     */
    public function search(array $data): void{
        $jSONsEARCH['type'] = 'ok';
        $jSONsEARCH['info'] = $data;
        $_SESSION[$data['action']] = $jSONsEARCH;
        echo json_encode($jSONsEARCH);
        return;
    }

    /**
     * @param array $data
     * @return void
     */
    public function searchRead(array $data): void{
        unset($_SESSION[$data['action']]['info']['search']);
        echo json_encode($_SESSION[$data['action']]);
        return;
    }

    /**
     * @param array $forms
     * @return void
     */
    public function eliminate(array $forms)
    {
        $data['company_trash'] = '1';

        if($this->db()->update('company')->where('company_id')->is($forms['id'])->andWhere('company_id_user')->is(ID_LOG)->set($data)){
            $this->call(
                '200',
                'Parabéns',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "ok",
                "Operação realizada com sucesso."
            )->back(["count" => 0]);
            return;
        }

        $this->call(
            '200',
            'Ops',
            '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
            "error",
            "Houve um problema no processamento da solicitação."
        )->back(["count" => 0]);
        return;
    }


    public function sendTags(array $data):void
    {
        if($data['type'] == ''){
            $this->call(
                '200',
                'Ops',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "error",
                "Existem campos em branco"
            )->back(["count" => 0]);
            return;
        }

        $result = $this->db()->from('sped_arquivo')
            ->where('sped_arquivo_id')->is($data['id'])
            ->andWhere('sped_arquivo_id_user')->is(ID_LOG)
            ->select()
            ->all();

        $explode_validador = explode(',', $data['tags']);
        $randFolder = ID_LOG.date('Ymd').'-'.rand(100000,999999);


        if($result){
            foreach($result as $r){

                if(mkdir('shared/temp/'.$randFolder.'/', 0777, true)){

                }
                for($x=0;$x<count($explode_validador);$x++){
                    $archive[$explode_validador[$x]] = fopen('shared/temp/'.$randFolder.'/'.$explode_validador[$x].'.txt', "w");
                }
                $archive['junto'] = fopen('shared/temp/'.$randFolder.'/todos.txt', "w");
                if($data['type'] == '0'){
                    $handle = fopen($r->sped_arquivo_contribuicoes, 'r');
                }elseif($data['type'] == '1'){
                    $handle = fopen($r->sped_arquivo_fiscal, 'r');
                }


                if($handle){
                    while(!feof($handle)){
                        $row = fgets($handle);

                        $explode_line = explode('|', $row);
                        for($x=0;$x<count($explode_validador);$x++){
                            if($explode_validador[$x] == $explode_line['1']){
                                $content[$explode_validador[$x]] .= $row;
                                $content['junto'] .= $row;
                            }
                        }
                    }
                    $zip = new \ZipArchive();
                    $arqZip = 'shared/zipex/' . $randFolder . '.zip';
                    $zip->open($arqZip, \ZipArchive::CREATE);
                    for($x=0;$x<count($explode_validador);$x++){
                        fwrite($archive[$explode_validador[$x]], $content[$explode_validador[$x]]);
                        fclose($archive[$explode_validador[$x]]);

                        $lines = file('shared/temp/'.$randFolder.'/'.$explode_validador[$x].'.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                        $conteudo = implode("\n", $lines);
                        file_put_contents('shared/temp/'.$randFolder.'/'.$explode_validador[$x].'.txt', $conteudo);

                        $zip->addFile('shared/temp/'.$randFolder.'/'.$explode_validador[$x].'.txt', $explode_validador[$x].'.txt');
                    }
                    fwrite($archive['junto'], $content['junto']);
                    fclose($archive['junto']);

                    $lines = file('shared/temp/'.$randFolder.'/todos.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                    $conteudo = implode("\n", $lines);
                    file_put_contents('shared/temp/'.$randFolder.'/todos.txt', $conteudo);

                    $zip->addFile('shared/temp/'.$randFolder.'/todos.txt', 'todos.txt');
                    $zip->close();


                    $linkZip = '<a href="../../'.$arqZip.'" class="btn btn-brown" download>BAIXAR OS ARQUIVOS</a>';

                    $this->call(
                        '200',
                        'Parabéns',
                        '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                        "ok",
                        "Documento processado com sucesso"
                    )->back(["button" => $linkZip]);
                    return;
                }
            }
        }

        $this->call(
            '200',
            'Ops',
            '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
            "error",
            "Não localizei o registro"
        )->back(["count" => 0]);
        return;
    }


    public function exportExcel(array $data):void
    {
        if($data['type'] == ''){
            $this->call(
                '200',
                'Ops',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "error",
                "Existem campos em branco"
            )->back(["count" => 0]);
            return;
        }

        $result = $this->db()->from('sped_arquivo')
            ->where('sped_arquivo_id')->is($data['id'])
            ->andWhere('sped_arquivo_id_user')->is(ID_LOG)
            ->select()
            ->all();

        
        if($result){
            foreach($result as $r){

                if($data['type'] == '0'){
                    $handle = fopen($r->sped_arquivo_contribuicoes, 'r');
                }elseif($data['type'] == '1'){
                    $handle = fopen($r->sped_arquivo_fiscal, 'r');
                }
                if($handle){
                    while(!feof($handle)){
                        $row = fgets($handle);
                        $explode_line = explode('|', $row);
        
                        if($explode_line[0] == '0000'){
                            $rows_plan_0000[] = $explode_line;
                        }
                        if($explode_line[0] == '0001'){
                            $rows_plan_0001[] = $explode_line;
                        }
                    }
                }
            }
        }

        print_r($rows_plan_0001);

        /*
        if($handle){
            while(!feof($handle)){
                $row = fgets($handle);
                $explode_line = explode('|', $row);
                print_r($explode_line);

                if($explode_line[0] == '0000'){
                    print_r($explode_line);
                    $rows_plan_0000[] = $explode_line;
                }
                if($explode_line[0] == '0001'){
                    $rows_plan_0001[] = $explode_line;
                }
            }
        }*/

        /**PLANILHA 0000 */
        $plan_0000 = '0000';
        $header_plan_0000 = array(
            'REG' => 'string',
            'COD_VER' => 'string',
            'TIPO_ESCRIT' => 'string',
            'IND_SIT_ESP' => 'string',
            'NUM_REC_ANTERIOR' => 'string',

            'DT_INI' => 'string',
            'DT_FIN' => 'string',
            'NOME' => 'string',
            'CNPJ' => 'string',
            'UF' => 'string',
            'COD_MUN' => 'string',
            'SUFRAMA' => 'string',
            'IND_NAT_PJ' => 'string',
            'IND_ATIV' => 'string'
        );

        /**PLANILHA 0001 */
        $plan_0001 = '0000';
        $header_plan_0001 = array(
            'REG' => 'string',
            'IND_MOV' => 'string'
        );


        /*$writer = new XLSXWriter();
        $writer->writeSheetHeader('0000', $header_plan_0000);
        $writer->writeSheetHeader('0001', $header_plan_0001);

        foreach($rows_plan_0000 as $row)
            $writer->writeSheetRow('0000', $row);
        
        foreach($rows_plan_0001 as $row)
            $writer->writeSheetRow('0001', $row);    

        $writer->writeToFile('xlsx-sheets.xlsx');    */
    }
}
