<?php

namespace Source\Models;
use Source\Conn\DataLayer;

/**
 * CLASSE RESPONSÁVEL PELO RETORNO DOS SELECT
 *
 * @author marques
 */
class Select extends DataLayer {

    /**
     * @param array $data
     * @return void
     */
    public function segmento(array $data)
    {
        $result = $this->db()->from('segmento')
            ->where('segmento_lixeira')->is(0)
            ->select()
            ->all();

        if($result){
            foreach ($result as $r){
                $rows['data'][] = $r;
            }
            echo json_encode($rows);
            return;
        }
    }

    /**
     * @param array $data
     * @return void
     */
    public function categoria(array $data)
    {
        $result = $this->db()->from('categoria')
            ->where('categoria_lixeira')->is(0)
            ->select()
            ->all();

        if($result){
            foreach ($result as $r){
                $rows['data'][] = $r;
            }
            echo json_encode($rows);
            return;
        }
    }
    
    public function marca(array $data)
    {
        $result = $this->db()->from('marca')
            ->where('marca_lixeira')->is(0)
            ->select()
            ->all();

        if($result){
            foreach ($result as $r){
                $rows['data'][] = $r;
            }
            echo json_encode($rows);
            return;
        }
    }
    
    public function categoriaPai(array $data)
    {
        $result = $this->db()->from('categoria')
            ->where('categoria_lixeira')->is(0)
            ->andWhere('categoria_id_pai')->is(0)
            ->select()
            ->all();

        if($result){
            foreach ($result as $r){
                $rows['data'][] = $r;
            }
            echo json_encode($rows);
            return;
        }
    }

    /**
     * @param array $data
     * @return void
     */
    public function variacao(array $data)
    {
        $result = $this->db()->from('variacao')
            ->where('variacao_lixeira')->is(0)
            ->select()
            ->all();

        if($result){
            foreach ($result as $r){
                $rows['data'][] = $r;
            }
            echo json_encode($rows);
            return;
        }
    }

    public function iconeCategoria(array $data)
    {
        $result = $this->db()->from('icone')
            ->orderBy('icone_descricao')
            ->select()
            ->all();

        if($result){
            foreach ($result as $r){
                $r->icone_descricao = $r->icone_descricao;
                $rows['data'][] = $r;
            }
            echo json_encode($rows);
            return;
        }
    }
    
    public function empresa(array $data)
    {
        $result = $this->db()->from('certificado')
            ->where('certificado_id_contato')->is($data['id_contato'])    
            ->andWhere('certificado_lixeira')->is(0)    
            ->orderBy('certificado_nome')
            ->select()
            ->all();

        if($result){
            foreach ($result as $r){
                $rows['data'][] = $r;
            }
            echo json_encode($rows);
            return;
        }
    }
}