<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace Source\Models;
use Source\Conn\DataLayer;

/**
 * CLASSE RESPOSÁVEL PELO CONTROLE DE LOGIN
 *
 * @author marques
 */
class Login extends DataLayer {

    /**
     * @param array $forms
     * @return void
     */
    public function send(array $forms)
    {
        if(in_array('', $forms)){
            $this->call(
                '200',
                'Ops',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "error",
                "Todos os campos devem ser preenchidos."
            )->back(["count" => 0]);
            return;
        }


        
        $result = $this->db()->from('user')
            ->where('user_email')->is($forms['user_email'])
            ->andWhere('user_senha')->is($forms['user_senha'])    
            ->select()
            ->all();


        if($result){
            foreach($result as $r){
                $_SESSION[SESSION] = $r;
            }
            $this->call(
                '200',
                'Parabéns',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "ok",
                "Operação realizada com sucesso."
            )->back(["count" => 0]);
            return;
        }

        $this->call(
            '200',
            'Ops',
            '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
            "error",
            "Registros não foram encontrados."
        )->back(["count" => 0]);
        return;
    }

    public function register(array $forms)
    {
        if(in_array('', $forms)){
            $this->call(
                '200',
                'Ops',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "error",
                "Todos os campos devem ser preenchidos"
            )->back(["count" => 0]);
            return;
        }

        $readUserEmail = $this->db()->from('user')
            ->where('user_email')->is($forms['user_email'])
            ->select()
            ->all();

        if($readUserEmail){
            $this->call(
                '200',
                'Ops',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "error",
                "Já existe um cadastro com esse email"
            )->back(["count" => 0]);
            return;
        }

        $readUserDoc = $this->db()->from('user')
            ->where('user_cpf')->is($forms['user_cpf'])
            ->select()
            ->all();

        if($readUserDoc){
            $this->call(
                '200',
                'Ops',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "error",
                "Já existe um cadastro com esse cpf"
            )->back(["count" => 0]);
            return;
        }

        if(!validate_cpf($forms['user_cpf'])){
            $this->call(
                '200',
                'Ops',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "error",
                "CPF inválido"
            )->back(["count" => 0]);
            return;
        }

        if(!validate_email($forms['user_email'])){
            $this->call(
                '200',
                'Ops',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "error",
                "Email inválido"
            )->back(["count" => 0]);
            return;
        }

        $forms['user_nivel'] = '1';
        $forms['user_responsavel'] = '1';
        $forms['user_atendimento'] = '1';

        if($this->db()->insert($forms)->into('user')){

            $idUser = $this->lastRegistro('user', 'user_id', 'user_id');

            $createBuy['buy_id_user'] = $idUser;
            $createBuy['buy_date'] = date('Y-m-d');
            $createBuy['buy_status'] = '1';
            $createBuy['buy_value'] = '0';
            $createBuy['buy_quantify'] = '30';
            $this->db()->insert($createBuy)->into('buy');

            $this->call(
                '200',
                'Parabéns',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "ok",
                "Operação realizada com sucesso."
            )->back(["count" => 0]);
            return;
        }

        $this->call(
            '200',
            'Ops',
            '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
            "error",
            "Houve um problema no processamento da solicitação."
        )->back(["count" => 0]);
        return;
    }
}