<?php

namespace Source\Models;

use Source\Conn\DataLayer;
use Ifsnop\Mysqldump as IMysqldump;

/**
 * CLASSE RESPONSÁVEL PELA CRIAÇÃO DO BKP COMPLETO DO BANCO DE DADOS
 */
class Dump extends DataLayer
{

    /**
     * @return void
     */
    public function bkp(){
        $name_bkp = date('YmdHis').'_'.rand(100,999).'.sql';

        try {
            $dump = new IMysqldump\Mysqldump(DSN, USER, PASS);
            $dump->start('shared/database/'.$name_bkp);
            $this->call(
                '200',
                'Parabéns',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "ok",
                "O Backup foi gerado com sucesso!"
            )->back(["count" => 0]);
            return;
        } catch (\Exception $e) {
            $this->call(
                '200',
                'Ops',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "error",
                "Houve um problema ao tentar gerar o banco de dados."
            )->back(["count" => 0]);
            return;
        }
    }

}