<?php

namespace Source\Models;

use Source\Conn\DataLayer;

class Config extends DataLayer
{
    public function setUser(array $data): void
    {
        $result = $this->db()->from('user')
            ->where('user_id')->is($data['id'])
            ->select()
            ->all();

        if($result){
            foreach ($result as $r){
                if($r->user_status == '0'){
                    $r->user_status = 'ATIVO';
                }else{
                    $r->user_status = 'INATIVO';
                }
                $_SESSION['id_user'] = $r->user_id;
                $_SESSION['name_user'] = $r->user_nome.' | '.$r->user_email.' | '.$r->user_status;


            }
            $this->call(
                '200',
                'Parabéns',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "ok",
                "Operação realizada com sucesso."
            )->back(["count" => 0]);
            return;
        }
        unset($_SESSION['id_user']);
        unset($_SESSION['name_user']);
        $this->call(
            '200',
            'Ops',
            '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
            "error",
            "Houve um problema no processamento da solicitação."
        )->back(["count" => 0]);
        return;
    }

    public function clearUser(array $data): void
    {
        unset($_SESSION['id_user']);
        unset($_SESSION['name_user']);
        $this->call(
            '200',
            'Parabéns',
            '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
            "ok",
            "Operação realizada com sucesso."
        )->back(["count" => 0]);
        return;
    }

    public function manageRobot(array $data): void
    {

        $statusRobot = get_autenticate(ID_LOG, 'user_atendimento');

        if($statusRobot == 0){
            $form['user_atendimento'] = '1';
            $this->db()->update('user')->where('user_id')->is(ID_LOG)->set($form);
        }
        if($statusRobot == 1){
            $form['user_atendimento'] = '0';
            $this->db()->update('user')->where('user_id')->is(ID_LOG)->set($form);
        }

        $this->call(
            '200',
            'Parabéns',
            '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
            "ok",
            "Operação realizada com sucesso."
        )->back(["count" => 0]);
        return;
    }


}