<?php

namespace Source\Models;
use Source\Conn\DataLayer;

class AutoComplete extends DataLayer
{
    public function company(array $data): void{
        $result = $this->db()->from('company')
            ->where('company_name')->like('%'.$data['search'].'%')
            ->andWhere('company_trash')->is(0)
            ->andWhere('company_id_user')->is(ID_LOG)
            ->limit(25)
            ->select()
            ->all();


        if($result){
            $returnDado = '[';
            foreach ($result as $r){
                $returnDado .= '{"label":"'.$r->company_name.' | '.$r->company_email.' | '.$r->company_cpf_cnpj.'","value":"'.$r->company_id.'"},';
            }
            $return = substr($returnDado, 0,-1);
            $return .= ']';
            echo $return;
            return;
        }else{
            $return = '[{"label":"Não encontrado","value":""}]';
            echo $return;
            return;
        }
    }

    public function companyComplete(array $data): void{
        $result = $this->db()->from('company')
            ->where('company_id_user')->is(ID_LOG)
            ->andWhere('company_trash')->is(0)
            ->andWhere('company_name')->like('%'.$data['search'].'%')
            ->orWhere('company_fantasy')->like('%'.$data['search'].'%')
            ->orWhere('company_cpf_cnpj')->like('%'.$data['search'].'%')
            ->orWhere('company_email')->like('%'.$data['search'].'%')
            ->limit(25)
            ->select()
            ->all();


        if($result){
            $returnDado = '[';
            foreach ($result as $r){
                if($r->company_id_user == ID_LOG){
                    $returnDado .= '{"label":"'.$r->company_name.' | '.$r->company_email.' | '.$r->company_cpf_cnpj.'","value":"'.$r->company_id.'"},';
                }
            }
            $return = substr($returnDado, 0,-1);
            $return .= ']';
            echo $return;
            return;
        }else{
            $return = '[{"label":"Não encontrado","value":""}]';
            echo $return;
            return;
        }
    }

    public function user(array $data): void{
        $result = $this->db()->from('user')
            ->where('user_nome')->like('%'.$data['search'].'%')
            ->andWhere('user_nivel')->is(1)
			->andWhere('user_id')->isNot(35)
            ->limit(25)
            ->select()
            ->all();


        if($result){
            $returnDado = '[';
            foreach ($result as $r){
                if($r->user_status == '0'){
                    $r->user_status = 'ATIVO';
                }else{
                    $r->user_status = 'INATIVO';
                }
                $returnDado .= '{"label":"'.$r->user_nome.' | '.$r->user_email.' | '.$r->user_status.'","value":"'.$r->user_id.'"},';
            }
            $return = substr($returnDado, 0,-1);
            $return .= ']';
            echo $return;
            return;
        }else{
            $return = '[{"label":"Não encontrado","value":""}]';
            echo $return;
            return;
        }
    }
}
