<?php

namespace Source\Helpers;

use Source\Conn\DataLayer;
use Dompdf\Dompdf;

class PDF extends DataLayer
{

    public function renderPDFReportFinanceiro(array $data): void
    {
        $query_paginator = $this->db()->from('financeiro')->join('contato', function($join){
            $join->on('contato_id', 'financeiro_id_contato');
        })->where('financeiro_id')->isNot(0);

        if($data['nome'] != ''){
            $query_paginator = $query_paginator->andWhere('financeiro_descricao')->like('%'.$forms['nome'].'%');
        }

        if($data['data_inicial'] != '' && $data['data_final'] != ''){
            $query_paginator = $query_paginator->andWhere($data['tipo'])->between($data['data_inicial'], $data['data_final']);
        }

        if($data['id_contato'] != ''){
            $query_paginator = $query_paginator->andWhere('financeiro_id_contato')->is($data['id_contato']);
        }

        if($data['status'] != ''){
            $query_paginator = $query_paginator->andWhere('financeiro_status')->is($data['status']);
        }

        $res_paginator = $query_paginator->select()->all();

        $reg = '';

        $valor_aberto = '0';
        $valor_pago = '0';
        $valor_cancelado = '0';
        if($res_paginator){
            foreach($res_paginator as $r){
                if($r->financeiro_status == '0'){
                    $r->financeiro_status = 'ATIVO';
                    $r->financeiro_data_pagamento = '';
                    $r->financeiro_valor_pagamento = '';

                    $valor_aberto += $r->financeiro_valor;
                }elseif($r->financeiro_status == '1'){
                    $r->financeiro_status = 'PAGO';
                    $r->financeiro_valor_pagamento = format_money($r->financeiro_valor_pagamento);
                    $r->financeiro_data_pagamento = format_date_br($r->financeiro_data_pagamento);

                    $valor_pago += $r->financeiro_valor_pagamento;
                }else{
                    $r->financeiro_status = 'CANCELADO';
                    $r->financeiro_data_pagamento = '';
                    $r->financeiro_valor_pagamento = '';

                    $valor_cancelado += $r->financeiro_valor;
                }
                $reg .= '<tr>
    <td>'.$r->financeiro_id.'</td>
    <td>'.$r->contato_nome_razao.'</td>
    <td>'.$r->financeiro_status.'</td>
    <td>'.format_money($r->financeiro_valor).'</td>
    <td>'.format_date_br($r->financeiro_data_vencimento).'</td>
    <td>'.$r->financeiro_valor_pagamento.'</td>
    <td>'.$r->financeiro_data_pagamento.'</td>
</tr>';
            }

            $title_reg = '<tr>
                <th>ID</th>
                <th>CLIENTE</th>
                <th>STATUS</th>
                <th>VALOR</th>
                <th>VENCIMENTO</th>
                <th>VLR PGTO</th>
                <th>DT PAGTO</th>
            </tr>';

            $tot = '<tr>
                        <td align="right">Quantidade: <b>'.count($res_paginator).'</b></td>
                    </tr>
                    <tr>
                        <td align="right">Valor Aberto: <b>R$ '.format_money($valor_aberto).'</b></td>
                    </tr>
                    <tr>
                        <td align="right">Valor Pago: <b>R$ '.format_money($valor_pago).'</b></td>
                    </tr>
                    <tr>
                        <td align="right">Valor Cancelado: <b>R$ '.format_money($valor_cancelado).'</b></td>
                    </tr>';

            $html_report = HTML_PRINT_A4;
            $html_report = str_replace('#LOG_REPORT#', 'EC', $html_report);
            $html_report = str_replace('#TITULO_REPORT#', 'Relatório financeiro', $html_report);
            $html_report = str_replace('#DATA_HORA_REPORT#', 'Gerado em '.date('d/m/Y').' as '.date('H:i'), $html_report);
            $html_report = str_replace('#TITLE_REG_REPORT#', $title_reg, $html_report);
            $html_report = str_replace('#REG_REPORT#', $reg, $html_report);
            $html_report = str_replace('#TOT_REPORT#', $tot, $html_report);

            $name = rand(100000,999999).'.pdf';
            $rand_archive = 'shared/report/pdf/'.$name;

            $dompdf = new Dompdf();
            $dompdf->loadHtml($html_report);
            $dompdf->setPaper('A4', 'landscape');
            $dompdf->render();
            $pdf = $dompdf->output();
            file_put_contents($rand_archive,$pdf);

            $this->call(
                '200',
                'Parabéns',
                '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
                "ok",
                "Operação realizada com sucesso."
            )->back(["arquivo" => $name]);
            return;
        }


        $this->call(
            '200',
            'Ops',
            '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>',
            "error",
            "Sem registros para mostrar no relatório"
        )->back(["count" => 0]);
        return;
    }

}