<?php

function download($filename, $filepath, $base64_encoded_file_data) {
    if (ob_get_level()) {
        ob_end_clean();
    }

    $decoded_file_data = base64_decode($base64_encoded_file_data);

    file_put_contents($filepath, $decoded_file_data);

    header('Expires: 0');
    header('Pragma: public');
    header('Cache-Control: must-revalidate');
    header('Content-Length: ' . filesize($filepath));
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    readfile($filepath);

    if (file_exists($filepath)) {
        //unlink($filepath);
    }
}

/**
 * @param array $string
 * @return false|string
 */
function converterJson(array $string)
{
    $result = json_encode($string, true);
    return $result;
}

/**
 * @param string $path
 * @param $time
 * @return string
 */
function asset(string $path, $time = true) : string{

    $file = SITE["root"]."/views/assets/{$path}";
    $fileOnDir = dirname(__DIR__, 1)."/views/assets/{$path}";
    if($time && file_exists($fileOnDir)){
        $file.= "?time=". filemtime($fileOnDir);
    }
    return $file;
}

/**
 * @param string|null $param
 * @return string
 */
function site(string $param = null) : string{

    if($param && !empty(SITE[$param])){
        return SITE[$param];
    }

    return SITE["root"];
}

/**
 * @param $buffer
 * @return string
 */
function translate_similar_chars($buffer) {
    $single_double = array(
        'Æ' => 'AE',
        'æ' => 'ae'
    );

    $buffer = strtr(
        $buffer,
        $single_double
    );

    $buffer = strtr(
        utf8_decode($buffer),
        utf8_decode('áàâäãåÁÀÂÄÃÅÞþßćčçĆČÇđĐÐéèêëÉÈÊËíìîïÍÌÎÏñÑóòôöõðøÓÒÔÖÕŕŔšŠ$úùûüÚÙÛÜýÿÝžŽØªº¹²³'),
        utf8_decode('aaaaaaAAAAAAbbBcccCCCdDDeeeeEEEEiiiiIIIInNoooooooOOOOOrRsSSuuuuUUUUyyYzZ0ao123')
    );

    $buffer = utf8_encode($buffer);

    return $buffer;
}

/**
 *
 * @param string $buffer
 * @return type
 */
function slug(string $buffer) {
    $buffer = html_entity_decode($buffer);                       // Converte todas as entidades HTML para os seus caracteres
    $buffer = translate_similar_chars($buffer);                  // Converte caracteres que não estão no padrão para representações deles
    $buffer = strtolower($buffer);                               // Converte uma string para minúscula
    $buffer = preg_replace("/[\s]+/", " ", $buffer);             // Comprime múltiplas ocorrências de espaços
    $buffer = preg_replace("/[_]+/", "_", $buffer);              // Comprime múltiplas ocorrências de underscores
    $buffer = preg_replace("/[-]+/", "-", $buffer);              // Comprime múltiplas ocorrências de hífens
    $buffer = preg_replace("/[\/]+/", "-", $buffer);             // Comprime múltiplas ocorrências de barras
    $buffer = preg_replace("/[\\\]+/", "-", $buffer);            // Comprime múltiplas ocorrências de barras invertidas
    $buffer = preg_replace("/[[\s]+]?-[[\s]+]?/", "-", $buffer); // Remove espaços antes e após hífens
    $buffer = preg_replace("/[\s]/", "-", $buffer);              // Converte espaços em hífens
    $buffer = preg_replace("/[_]/", "-", $buffer);               // Converte underscores em hífens
    $buffer = preg_replace("/[\/]/", "-", $buffer);              // Converte barras em hífens
    $buffer = preg_replace("/[\\\]/", "-", $buffer);             // Converte barras invertidas em hífens
    $buffer = preg_replace("/[^a-z0-9_-]/", "", $buffer);      // Remove caracteres que não estejam no padrão

    return $buffer;
}


/**
 * @param $value
 * @return string
 */
function format_money($value){
    return number_format($value, 2, ',', '.');
}

/**
 * @param $value
 * @return false|string
 */
function format_datetime_br($value){
    return date("d/m/Y H:i:s", strtotime($value));
}

/**
 * @param $value
 * @return false|string
 */
function format_date_br($value){
    return date("d/m/Y", strtotime($value));
}

/**
 * @param $data
 * @return bool
 */
function validar_data($data){
    $d = explode('-', $data);

    if(checkdate($d['1'], $d['2'], $d['0'])){
        return true;
    }
    return false;
}

function validate_cpf($cpf) {
    $cpf = preg_replace( '/[^0-9]/is', '', $cpf );

    if (strlen($cpf) != 11) {
        return false;
    }

    if (preg_match('/(\d)\1{10}/', $cpf)) {
        return false;
    }

    for ($t = 9; $t < 11; $t++) {
        for ($d = 0, $c = 0; $c < $t; $c++) {
            $d += $cpf[$c] * (($t + 1) - $c);
        }
        $d = ((10 * $d) % 11) % 10;
        if ($cpf[$c] != $d) {
            return false;
        }
    }
    return true;
}

function validate_email($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL);
}


function get_gravatar($email){
    $default = "https://upload.wikimedia.org/wikipedia/commons/thumb/e/ed/Item_sem_imagem.svg/1024px-Item_sem_imagem.svg.png";
    $size = 40;
    $grav_url = "https://www.gravatar.com/avatar/" . md5( strtolower( trim( $email ) ) ) . "?d=" . urlencode( $default ) . "&s=" . $size;

    return $grav_url;
}

function get_config($column){
    $db = new Source\Conn\DataLayer();

    $result = $db->db()->from('configuracao')
        ->where('configuracao_id')->is(1)
        ->limit(1)
        ->select()
        ->all();

    if($result){
        foreach($result as $r){
            return $r->$column;
        }
    }
}

function get_dashboard($tipo){
    $db = new Source\Conn\DataLayer();

    if($tipo == '0'){
        if($_SESSION[SESSION]->user_nivel == '0'){
            $result = $db->db()->from('xml')
                ->where('xml_trash')->is(0)
                ->andWhere('xml_status')->is(0)
                ->select()
                ->all();
        }else{
            $result = $db->db()->from('xml')
                ->where('xml_trash')->is(0)
                ->andWhere('xml_status')->is(0)
                ->andWhere('xml_id_user')->is(ID_LOG)
                ->select()
                ->all();
        }
    }elseif($tipo == '1'){
        if($_SESSION[SESSION]->user_nivel == '0'){
            $result = $db->db()->from('xml')
                ->where('xml_trash')->is(0)
                ->andWhere('xml_status')->is(2)
                ->select()
                ->all();
        }else{
            $result = $db->db()->from('xml')
                ->where('xml_trash')->is(0)
                ->andWhere('xml_status')->is(2)
                ->andWhere('xml_id_user')->is(ID_LOG)
                ->select()
                ->all();
        }
    }elseif($tipo == '2'){
        if($_SESSION[SESSION]->user_nivel == '0'){
            $result = $db->db()->from('xml')
                ->where('xml_trash')->is(0)
                ->andWhere('xml_status')->is(1)
                ->select()
                ->all();
        }else{
            $result = $db->db()->from('xml')
                ->where('xml_trash')->is(0)
                ->andWhere('xml_status')->is(1)
                ->andWhere('xml_id_user')->is(ID_LOG)
                ->select()
                ->all();
        }
    }elseif($tipo == '3'){
        if($_SESSION[SESSION]->user_nivel == '0'){
            $result = $db->db()->from('xml')
                ->where('xml_trash')->is(0)
                ->andWhere('xml_status')->is(3)
                ->select()
                ->all();
        }else{
            $result = $db->db()->from('xml')
                ->where('xml_trash')->is(0)
                ->andWhere('xml_status')->is(3)
                ->andWhere('xml_id_user')->is(ID_LOG)
                ->select()
                ->all();
        }
    }


    if($result){
        return count($result);
    }else{
        return '0';
    }
}

function get_balance($id_user){
    $db = new Source\Conn\DataLayer();

    $resultBuy = $db->db()->from('buy')
        ->where('buy_id_user')->is($id_user)
        ->andWhere('buy_status')->is(1)
        ->select(function($include){
            $include->sum('buy_quantify', 'total');
        })
        ->all();

    if($resultBuy){
        foreach ($resultBuy as $rBuy){
            if($rBuy->total != ''){
                $totalKeys = $rBuy->total;
            }else{
                $totalKeys = 0;
            }
        }
    }else{
        $totalKeys = 0;
    }




    return ($totalKeys - $totalXml);
}

function get_autenticate($id_user, $column){
    $db = new Source\Conn\DataLayer();

    $result = $db->db()->from('user')
        ->where('user_id')->is($id_user)
        ->select()
        ->all();

    if($result){
        foreach ($result as $r){
            return $r->$column;
        }
    }


    return false;
}
