<?php

namespace Source\Controllers;
use League\Plates\Engine;

/**
 *
 */
class Sped
{
    /**
     * @var Engine
     */
    private $view;

    /**
     * Account constructor.
     */
    public function __construct($router)
    {
        $this->view = Engine::create(__DIR__ . "/../../views/theme", "php");
        $this->view->addData(["router" => $router]);
    }

    /**
     *
     */
    public function index(): void
    {
        echo $this->view->render("sped/index", [
            "title" => "Sped | " . SITE['name']
        ]);
    }

    /**
     * @return void
     */
    public function create(): void
    {
        echo $this->view->render("sped/create", [
            "title" => "sped | " . SITE['name']
        ]);
    }

    /**
     * @param $data
     * @return void
     */
    public function update($data): void
    {
        echo $this->view->render("sped/update", [
            "title" => "sped | " . SITE['name'],
            "param" => $data
        ]);
    }

    /**
     * @param $data
     * @return void
     */
    public function view($data): void
    {
        echo $this->view->render("sped/view", [
            "title" => "sped | " . SITE['name'],
            "param" => $data
        ]);
    }

    public function delete($data): void
    {
        echo $this->view->render("sped/delete", [
            "title" => "Sped | " . SITE['name'],
            "param" => $data
        ]);
    }
}
