<?php

namespace Source\Controllers;
use League\Plates\Engine;

/**
 *
 */
class Finance
{
    /**
     * @var Engine
     */
    private $view;

    /**
     * Account constructor.
     */
    public function __construct($router)
    {
        $this->view = Engine::create(__DIR__ . "/../../views/theme", "php");
        $this->view->addData(["router" => $router]);
    }

    /**
     *
     */
    public function balance(): void
    {
        echo $this->view->render("finance/balance", [
            "title" => "Saldo | " . SITE['name']
        ]);
    }

    /**
     * @return void
     */
    public function credits(): void
    {
        echo $this->view->render("finance/credits", [
            "title" => "Créditos | " . SITE['name']
        ]);
    }

    /**
     * @return void
     */
    public function creditsBuy(): void
    {
        echo $this->view->render("finance/credits_buy", [
            "title" => "Comprar Créditos | " . SITE['name']
        ]);
    }
}