<?php

namespace Source\Controllers;

use League\Plates\Engine;

class Consult
{
    /**
     * @var Engine
     */
    private $view;

    /**
     * Account constructor.
     */
    public function __construct($router)
    {
        $this->view = Engine::create(__DIR__ . "/../../views/theme", "php");
        $this->view->addData(["router" => $router]);
    }

    /**
     *
     */
    public function index(): void
    {
        echo $this->view->render("consult/index", [
            "title" => "Consulta Dados | " . SITE['name']
        ]);
    }

    /**
     * @return void
     */
    public function create(): void
    {
        echo $this->view->render("consult/create", [
            "title" => "Consulta Dados | " . SITE['name']
        ]);
    }

    /**
     * @param $data
     * @return void
     */
    public function key($data): void
    {
        echo $this->view->render("consult/key", [
            "title" => "Consulta Dados | " . SITE['name'],
            "param" => $data
        ]);
    }

    public function delete($data): void
    {
        echo $this->view->render("consult/delete", [
            "title" => "Consulta Dados | " . SITE['name'],
            "param" => $data
        ]);
    }
}
