<?php

namespace Source\Controllers;
use League\Plates\Engine;

/**
 *
 */
class Company
{
    /**
     * @var Engine
     */
    private $view;

    /**
     * Account constructor.
     */
    public function __construct($router)
    {
        $this->view = Engine::create(__DIR__ . "/../../views/theme", "php");
        $this->view->addData(["router" => $router]);
    }

    /**
     *
     */
    public function index(): void
    {
        echo $this->view->render("company/index", [
            "title" => "Empresa | " . SITE['name']
        ]);
    }

    /**
     * @return void
     */
    public function create(): void
    {
        echo $this->view->render("company/create", [
            "title" => "Empresa | " . SITE['name']
        ]);
    }

    /**
     * @param $data
     * @return void
     */
    public function certificate($data): void
    {
        echo $this->view->render("company/certificate", [
            "title" => "Empresa | " . SITE['name'],
            "param" => $data
        ]);
    }

    public function download($data): void
    {
        echo $this->view->render("company/download", [
            "title" => "Empresa | " . SITE['name'],
            "param" => $data
        ]);
    }

    /**
     * @param $data
     * @return void
     */
    public function update($data): void
    {
        echo $this->view->render("company/update", [
            "title" => "Empresa | " . SITE['name'],
            "param" => $data
        ]);
    }

    public function delete($data): void
    {
        echo $this->view->render("company/delete", [
            "title" => "Empresa | " . SITE['name'],
            "param" => $data
        ]);
    }
}
