<?php


namespace Source\Controllers;


use League\Plates\Engine;

/**
 * Class App
 * @package Source\Controllers
 */
class App
{
    /**
     * @var Engine
     */
    private $view;
    /**
     * @var
     */
    protected $user;

    /**
     * App constructor.
     */

    public function __construct()
    {
        $this->view = Engine::create(__DIR__ . "/../../views/theme", "php");
        
        if(empty($_SESSION[SESSION])){
            if(end(explode('/', $_SERVER["REQUEST_URI"])) != 'login'){
                //header("Location: ". url('login/index')."");
            }
        }
    }

    /**
     *
     */
    public function home(): void
    {
        
        echo $this->view->render("home", [
            "title" => "Home | " . SITE
        ]);
    }
    
    public function login(): void
    {
        echo $this->view->render("login", [
            "title" => "Login | " . SITE
        ]);
    }

    /**
     *
     */
    public function logout(): void
    {
        session_destroy();
        header("Location: ".url()." ");
    }

    /**
     * @param array $data
     */
    public function error(array $data): void
    {
        echo $this->view->render("error", [
            "title" => "Error {$data['errcode']} |" . SITE,
            "error" => $data['errcode']
        ]);
    }
}