<?php
ini_set('display_errors', 'on');
date_default_timezone_set('America/Sao_Paulo');
ini_set('max_execution_time', 0);
error_reporting(E_ERROR | E_WARNING | E_PARSE);
ob_start();
session_start();
use CoffeeCode\Router\Router;

require __DIR__."/vendor/autoload.php";

$router = new Router(URL_BASE);

$explodeInfo = explode('/', $_SERVER["REQUEST_URI"]);
$typeConnection = $_SERVER['HTTP_HOST'];

if ($typeConnection == '10.0.0.249:8080'){
    if($explodeInfo['2'] != 'login'){
        if(empty($_SESSION[SESSION])){
            header("Location: ".url('login/index')." ");
        }
    }
}else{
    if($explodeInfo['2'] != 'login'){
        if(empty($_SESSION[SESSION])){
            header("Location: ".url('login/index')." ");
        }
    }
}

$router->namespace("Source\Controllers");

$router->get("/", "App:home", "app.home");
$router->get("/home", "App:home", "app.home");
$router->get("/logout", "App:logout", "app.logout");
$router->get("/login", "App:login", "app.login");

$router->group('/login');
$router->get("/index", "Login:index", "login.index");
$router->get("/create", "Login:create", "login.create");

$router->group('/company');
$router->get("/index", "Company:index", "company.index");
$router->get("/create", "Company:create", "company.create");
$router->get("/update/{uri}", "Company:update", "company.update");
$router->get("/delete/{uri}", "Company:delete", "company.delete");
$router->get("/certificate/{uri}", "Company:certificate", "company.certificate");
$router->get("/download/{uri}", "Company:download", "company.download");

$router->group('/xml_key_nfe');
$router->get("/index", "KeyNFe:index", "xml_key_nfe.index");
$router->get("/create", "KeyNFe:create", "xml_key_nfe.create");
$router->get("/key/{uri}", "KeyNFe:key", "xml_key_nfe.key");
$router->get("/delete/{uri}", "KeyNFe:delete", "xml_key_nfe.delete");

$router->group('/xml_key_nfce');
$router->get("/index", "KeyNFCe:index", "xml_key_nfce.index");
$router->get("/create", "KeyNFCe:create", "xml_key_nfce.create");
$router->get("/key/{uri}", "KeyNFCe:key", "xml_key_nfce.key");
$router->get("/delete/{uri}", "KeyNFCe:delete", "xml_key_nfce.delete");

$router->group('/xml_key_cte');
$router->get("/index", "KeyCTe:index", "xml_key_cte.index");
$router->get("/create", "KeyCTe:create", "xml_key_cte.create");
$router->get("/key/{uri}", "KeyCTe:key", "xml_key_cte.key");
$router->get("/delete/{uri}", "KeyCTe:delete", "xml_key_cte.delete");

$router->group('/consult');
$router->get("/index", "Consult:index", "consult.index");
$router->get("/create", "Consult:create", "consult.create");
$router->get("/key/{uri}", "Consult:key", "consult.key");
$router->get("/delete/{uri}", "Consult:delete", "consult.delete");

$router->group('/doc_nfe');
$router->get("/index", "DocNFe:index", "doc_nfe.index");

$router->group('/doc_nfse');
$router->get("/index", "DocNFSe:index", "doc_nfse.index");

$router->group('/sped');
$router->get("/index", "Sped:index", "sped.index");
$router->get("/create", "Sped:create", "sped.create");
$router->get("/view/{uri}", "Sped:view", "sped.view");

$router->group('/finance');
$router->get("/balance", "Finance:balance", "Finance.balance");
$router->get("/credits", "Finance:credits", "Finance.credits");
$router->get("/credits_buy", "Finance:creditsBuy", "Finance.creditsBuy");

$router->namespace("Source\Models");

$router->group('/login');
$router->post("/send", "Login:send", "login.send");
$router->post("/register", "Login:register", "login.register");


$router->group('/company');
$router->post("/insert", "Company:insert", "company.insert");
$router->post("/select", "Company:select", "company.select");
$router->post("/selectId", "Company:selectId", "company.selectId");
$router->post("/search", "Company:search", "company.search");
$router->post("/searchRead", "Company:searchRead", "company.searchRead");
$router->post("/eliminate", "Company:eliminate", "company.eliminate");
$router->post("/edit", "Company:edit", "company.edit");
$router->post("/searchCertificate", "Company:searchCertificate", "company.searchCertificate");
$router->post("/certificateCreate", "Company:certificateCreate", "company.certificateCreate");
$router->post("/certificateUpdate", "Company:certificateUpdate", "company.certificateUpdate");
$router->post("/certificateDelete", "Company:certificateDelete", "company.certificateDelete");

$router->group('/xml_key_nfe');
$router->post("/insert", "KeyNFe:insert", "xml_key_nfe.insert");
$router->post("/select", "KeyNFe:select", "xml_key_nfe.select");
$router->post("/selectId", "KeyNFe:selectId", "xml_key_nfe.selectId");
$router->post("/search", "KeyNFe:search", "xml_key_nfe.search");
$router->post("/searchRead", "KeyNFe:searchRead", "xml_key_nfe.searchRead");
$router->post("/eliminate", "KeyNFe:eliminate", "xml_key_nfe.eliminate");
$router->post("/selectKey", "KeyNFe:selectKey", "xml_key_nfe.selectKey");
$router->post("/zip", "KeyNFe:zip", "xml_key_nfe.zip");
$router->post("/loadLote", "KeyNFe:loadLote", "xml_key_nfe.loadLote");

$router->group('/xml_key_nfce');
$router->post("/insert", "KeyNFCe:insert", "xml_key_nfce.insert");
$router->post("/select", "KeyNFCe:select", "xml_key_nfce.select");
$router->post("/selectId", "KeyNFCe:selectId", "xml_key_nfce.selectId");
$router->post("/search", "KeyNFCe:search", "xml_key_nfce.search");
$router->post("/searchRead", "KeyNFCe:searchRead", "xml_key_nfce.searchRead");
$router->post("/eliminate", "KeyNFCe:eliminate", "xml_key_nfce.eliminate");
$router->post("/selectKey", "KeyNFCe:selectKey", "xml_key_nfce.selectKey");
$router->post("/zip", "KeyNFCe:zip", "xml_key_nfce.zip");
$router->post("/loadLote", "KeyNFCe:loadLote", "xml_key_nfce.loadLote");

$router->group('/xml_key_cte');
$router->post("/insert", "KeyCTe:insert", "xml_key_cte.insert");
$router->post("/select", "KeyCTe:select", "xml_key_cte.select");
$router->post("/selectId", "KeyCTe:selectId", "xml_key_cte.selectId");
$router->post("/search", "KeyCTe:search", "xml_key_cte.search");
$router->post("/searchRead", "KeyCTe:searchRead", "xml_key_cte.searchRead");
$router->post("/eliminate", "KeyCTe:eliminate", "xml_key_cte.eliminate");
$router->post("/selectKey", "KeyCTe:selectKey", "xml_key_cte.selectKey");
$router->post("/zip", "KeyCTe:zip", "xml_key_cte.zip");
$router->post("/loadLote", "KeyCTe:loadLote", "xml_key_cte.loadLote");

$router->group('/consult');
$router->post("/insert", "Consult:insert", "consult.insert");
$router->post("/select", "Consult:select", "consult.select");
$router->post("/selectId", "Consult:selectId", "consult.selectId");
$router->post("/search", "Consult:search", "consult.search");
$router->post("/searchRead", "Consult:searchRead", "consult.searchRead");
$router->post("/eliminate", "Consult:eliminate", "consult.eliminate");
$router->post("/selectKey", "Consult:selectKey", "consult.selectKey");
$router->post("/zip", "Consult:zip", "consult.zip");
$router->post("/loadLote", "Consult:loadLote", "consult.loadLote");

$router->group('/doc_nfe');
$router->post("/select", "DocNFe:select", "doc_nfe.select");
$router->post("/search", "DocNFe:search", "doc_nfe.search");
$router->post("/searchRead", "DocNFe:searchRead", "doc_nfe.searchRead");
$router->post("/searchDoc", "DocNFe:searchDoc", "doc_nfe.searchDoc");
$router->post("/processDoc", "DocNFe:processDoc", "doc_nfe.processDoc");
$router->post("/loadEvents", "DocNFe:loadEvents", "doc_nfe.loadEvents");
$router->post("/loadEventsXML", "DocNFe:loadEventsXML", "doc_nfe.loadEventsXML");
$router->post("/downloadEventsXML", "DocNFe:downloadEventsXML", "doc_nfe.downloadEventsXML");
$router->post("/manifesta", "DocNFe:manifesta", "doc_nfe.manifesta");
$router->post("/manifestaConsulta", "DocNFe:manifestaConsulta", "doc_nfe.manifestaConsulta");
$router->post("/download", "DocNFe:download", "doc_nfe.download");
$router->post("/downloadZip", "DocNFe:downloadZip", "doc_nfe.downloadZip");
$router->post("/danfe", "DocNFe:danfe", "doc_nfe.danfe");

$router->group('/doc_nfse');
$router->post("/select", "DocNFSe:select", "doc_nfse.select");
$router->post("/search", "DocNFSe:search", "doc_nfse.search");
$router->post("/searchRead", "DocNFSe:searchRead", "doc_nfse.searchRead");
$router->post("/searchDoc", "DocNFSe:searchDoc", "doc_nfse.searchDoc");
$router->post("/processDoc", "DocNFSe:processDoc", "doc_nfse.processDoc");
$router->post("/loadEvents", "DocNFSe:loadEvents", "doc_nfse.loadEvents");
$router->post("/loadEventsXML", "DocNFSe:loadEventsXML", "doc_nfse.loadEventsXML");
$router->post("/downloadEventsXML", "DocNFSe:downloadEventsXML", "doc_nfse.downloadEventsXML");
$router->post("/manifesta", "DocNFSe:manifesta", "doc_nfse.manifesta");
$router->post("/manifestaConsulta", "DocNFSe:manifestaConsulta", "doc_nfse.manifestaConsulta");
$router->post("/download", "DocNFSe:download", "doc_nfse.download");
$router->post("/downloadZip", "DocNFSe:downloadZip", "doc_nfse.downloadZip");
$router->post("/danfe", "DocNFSe:danfe", "doc_nfse.danfe");

$router->group('/sped');
$router->post("/insert", "Sped:insert", "sped.insert");
$router->post("/select", "Sped:select", "sped.select");
$router->post("/selectId", "Sped:selectId", "sped.selectId");
$router->post("/search", "Sped:search", "sped.search");
$router->post("/searchRead", "Sped:searchRead", "sped.searchRead");
$router->post("/eliminate", "Sped:eliminate", "sped.eliminate");

$router->post("/sendTags", "Sped:sendTags", "sped.sendTags");

$router->group('/finance');
$router->post("/balanceKey", "Finance:balanceKey", "finance.balanceKey");
$router->post("/buy", "Finance:buy", "finance.buy");
$router->post("/buyLoad", "Finance:buyLoad", "finance.buyLoad");

$router->group('/config');
$router->post("/setUser", "Config:setUser", "config.setUser");
$router->post("/clearUser", "Config:clearUser", "config.clearUser");
$router->post("/manageRobot", "Config:manageRobot", "config.manageRobot");

$router->group('/autocomplete');
$router->post("/company", "AutoComplete:company", "autocomplete.company");
$router->post("/companyComplete", "AutoComplete:companyComplete", "autocomplete.companyComplete");
$router->post("/user", "AutoComplete:user", "autocomplete.user");

$router->namespace("Source\Helpers");

$router->group('/pdf');
$router->post("/renderPDFReportFinance", "PDF:renderPDFReportFinance", "pdf.renderPDFReportFinance");


$router->dispatch();

ob_end_flush();
