<?php
ini_set('display_errors', 'on');
ini_set('max_execution_time', 0);


require_once 'vendor/autoload.php';

$db = new Source\Conn\DataLayer();

$result = $db->db()->from('sped_arquivo')
    ->where('sped_arquivo_id')->is(3)
    ->select()
    ->all();


const BLOCO_SPED_FISCAL = [
    '0000' => 'ID;ID_PAI;REG;COD_VER;COD_FIN;DT_INI;DT_FIN;NOME;CNPJ;CPF;UF;IE;COD_MUN;IM;SUFRAMA;IND_PERFIL;IND_ATIV',
    '0001' => 'ID;ID_PAI;REG;IND_MOV',
    '0002' => 'ID;ID_PAI;REG;CLAS_ESTAB_IND',
    '0005' => 'ID;ID_PAI;REG;FANTASIA;CEP;ENDERECO;NUM;COMPL;BAIRRO;FONE;FAX;EMAIL',
    '0015' => 'ID;ID_PAI;REG;UF_ST;IE_ST',
    '0100' => 'ID;ID_PAI;REG;NOME;CPF;CRC;CNPJ;CEP;ENDERECO;NUM;COMPL;BAIRRO;FONE;FAX;EMAIL;COD_MUN',
    '0150' => 'ID;ID_PAI;REG;COD_PART;NOME;COD_PAIS;CNPJ;CPF;IE;COD_MUN;SUFRAMA;ENDERECO;NUM;COMPL;BAIRRO',
    '0175' => 'ID;ID_PAI;REG;DT_ALT;NR_CAMPO;CONT_ANT',
    '0190' => 'ID;ID_PAI;REG;UNID;DESCR',
    '0200' => 'ID;ID_PAI;REG;COD_ITEM;DESCR_ITEM;COD_BARRA;COD_ANT_ITEM;UNID_INV;TIPO_ITEM;COD_NCM;EX_IPI;COD_GEN;COD_LST;ALIQ_ICMS;CEST',
    '0205' => 'ID;ID_PAI;REG;DESCR_ANT_ITEM;DT_INI;DT_FIM;COD_ANT_ITEM',
    '0206' => 'ID;ID_PAI;REG;COD_COMB',
    '0220' => 'ID;ID_PAI;REG;UNID_CONV;FAT_CONV;COD_BARRA',
    '0221' => 'ID;ID_PAI;REG;COD_ITEM_ATOMICO;QTD_CONTIDA',
    '0300' => 'ID;ID_PAI;REG;COD_IND_BEM;IDENT_MERC;DESCR_ITEM;COD_PRNC;COD_CTA;NR_PARC',
    '0305' => 'ID;ID_PAI;REG;COD_CCUS;FUNC;VIDA_UTIL',
    '0400' => 'ID;ID_PAI;REG;COD_NAT;DESCR_NAT',
    '0450' => 'ID;ID_PAI;REG;COD_INF;TXT',
    '0460' => 'ID;ID_PAI;REG;COD_OBS;TXT',
    '0500' => 'ID;ID_PAI;REG;DT_ALT;COD_NAT_CC;IND_CTA;NIVEL;COD_CTA;NOME_CTA',
    '0600' => 'ID;ID_PAI;REG;DT_ALT;COD_CCUS;CCUS',
    '0990' => 'ID;ID_PAI;REG;QTD_LIN_0',
    '1001' => 'ID;ID_PAI;REG;IND_MOV',
    '1010' => 'ID;ID_PAI;REG;IND_EXP;IND_CCRF;IND_COMB;IND_USINA;IND_VA;IND_EE;IND_CART;IND_FORM;IND_AER;IND_GIAF1;IND_GIAF3;IND_GIAF4;IND_REST_RESSARC_COMPL_ICMS',
    '1100' => 'ID;ID_PAI;REG;IND_DOC;NRO_DE;DT_DE;NAT_EXP;NRO_RE;DT_RE;CHC_EMB;DT_CHC;DT_AVB;TP_CHC;PAIS',
    '1105' => 'ID;ID_PAI;REG;COD_MOD;SER;NUM_DOC;CHV_NFE;DT_DOC;COD_ITEM',
    '1110' => 'ID;ID_PAI;REG;COD_PART;COD_MOD;SER;NUM_DOC;DT_DOC;CHV_NFE;NR_MEMO;QTD;UNID',
    '1200' => 'ID;ID_PAI;REG;COD_AJ_APUR;SLD_CRED;CRED_APR;CRED_RECEB;CRED_UTIL;SLD_CRED_FIM',
    '1210' => 'ID;ID_PAI;REG;TIPO_UTIL;NR_DOC;VL_CRED_UTIL;CHV_DOCE',
    '1250' => 'ID;ID_PAI;REG;VL_CREDITO_ICMS_OP;VL_ICMS_ST_REST;VL_FCP_ST_REST;VL_ICMS_ST_COMPL;VL_FCP_ST_COMPL',
    '1255' => 'ID;ID_PAI;REG;COD_MOT_REST_COMPL;VL_CREDITO_ICMS_OP_MOT;VL_ICMS_ST_REST_MOT;VL_FCP_ST_REST_MOT;VL_ICMS_ST_COMPL_MOT;VL_FCP_ST_COMPL_MOT',
    '1300' => 'ID;ID_PAI;REG;COD_ITEM;DT_FECH;ESTQ_ABERT;VOL_ENTR;VOL_DISP;VOL_SAIDAS;ESTQ_ESCR;VAL_AJ_PERDA;VAL_AJ_GANHO;FECH_FISICO',
    '1310' => 'ID;ID_PAI;REG;NUM_TANQUE;ESTQ_ABERT;VOL_ENTR;VOL_DISP;VOL_SAIDAS;ESTQ_ESCR;VAL_AJ_PERDA;VAL_AJ_GANHO;FECH_FISICO',
    '1320' => 'ID;ID_PAI;REG;NUM_BICO;NR_INTERV;MOT_INTERV;NOM_INTERV;CNPJ_INTERV;CPF_INTERV;VAL_FECHA;VAL_ABERT;VOL_AFERI;VOL_VENDAS',
    '1350' => 'ID;ID_PAI;REG;SERIE;FABRICANTE;MODELO;TIPO_MEDICAO',
    '1360' => 'ID;ID_PAI;REG;NUM_LACRE;DAT_APLICACAO',
    '1370' => 'ID;ID_PAI;REG;NUM_BICO;COD_ITEM;NUM_TANQUE',
    '1390' => 'ID;ID_PAI;REG;COD_PROD',
    '1391' => 'ID;ID_PAI;REG;DT_REGISTRO;QTD;ESTQ_INI;QTD_PRODUZ;ENT_ANID_HID;OUTR_ENTR;PERDA;CONS;SAI_ANI_HID;SAIDAS;ESTQ_FIN;ESTQ_INI_MEL;PROD_DIA_MEL;UTIL_MEL;PROD_ALC_MEL;OBS;COD_ITEM;TP_RESIDUO;QTD_RESIDUO',
    '1400' => 'ID;ID_PAI;REG;COD_ITEM_IPM;MUN;VALOR',
    '1500' => 'ID;ID_PAI;REG;IND_OPER;IND_EMIT;COD_PART;COD_MOD;COD_SIT;SER;SUB;COD_CONS;NUM_DOC;DT_DOC;DT_E_S;VL_DOC;VL_DESC;VL_FORN;VL_SERV_NT;VL_TERC;VL_DA;VL_BC_ICMS;VL_ICMS;VL_BC_ICMS_ST;VL_ICMS_ST;COD_INF;VL_PIS;VL_COFIS;TP_LIGACAO;COD_GRUPO_TENSAO',
    '1510' => 'ID;ID_PAI;REG;NUM_ITEM;COD_ITEM;COD_CLASS;QTD;UNID;VL_ITEM;VL_DESC;CST_ICMS;CFOP;VL_BC_ICMS;ALIQ_ICMS;VL_ICMS;VL_BC_ICMS_ST;ALIQ_ST;VL_ICMS_ST;IND_REC;COD_PART;VL_PIS;VL_COFIS;COD_CTA',
    '1601' => 'ID;ID_PAI;REG;COD_PART_IP;COD_PART_IT;TOT_VS;TOT_ISS;TOT_OUTROS',
    '1700' => 'ID;ID_PAI;REG;COD_DISP;COD_MOD;SER;SUB;NUM_DOC_INI;NUM_DOC_FIN;NUM_AUT',
    '1710' => 'ID;ID_PAI;REG;NUM_DOC_INI;NUM_DOC_FIN',
    '1800' => 'ID;ID_PAI;REG;VL_CARGA;VL_PASS;VL_FAT;IND_RAT;VL_ICMS_ANT;VL_BC_ICMS;VL_ICMS_APUR;VL_BC_ICMS_APUR;VL_DIF',
    '1900' => 'ID;ID_PAI;REG;IND_APUR_ICMS;DESCR_COMPL_OUT_APUR',
    '1910' => 'ID;ID_PAI;REG;DT_INI;DT_FIN',
    '1920' => 'ID;ID_PAI;REG;VL_TOT_TRANSF_DEBITOS_OA;VL_TOT_AJ_DEBITOS_OA;VL_ESTORNOS_CRED_OA;VL_TOT_TRANSF_CREDITOS_OA;VL_TOT_AJ_CREDITOS_OA;VL_ESTORNOS_DEB_OA;VL_SLD_CREDOR_ANT_OA;VL_SLD_APURADO_OA;VL_TOT_DED;VL_ICMS_RECOLHER_OA;VL_SLD_CREDOR_TRANSP_OA;DEB_ESP_OA',
    '1921' => 'ID;ID_PAI;REG;COD_AJ_APUR;DESCR_COMPL_AJ;VL_AJ_APUR',
    '1922' => 'ID;ID_PAI;REG;NUM_DA;NUM_PROC;IND_PROC;PROC;TXT_COMPL',
    '1923' => 'ID;ID_PAI;REG;COD_PART;COD_MOD;SER;SUB;NUM_DOC;DT_DOC;COD_ITEM;VL_AJ_ITEM;CHV_DOCE',
    '1925' => 'ID;ID_PAI;REG;COD_INF_ADIC;VL_INF_ADIC;DESC_COMPL_AJ',
    '1926' => 'ID;ID_PAI;REG;COD_OR;VL_OR;DT_VCTO;COD_REC;NUM_PROC;IND_PROC;PROC;TXT_COMPL;MES_REF',
    '1960' => 'ID;ID_PAI;REG;IND_AP;G1_01;G1_02;G1_03;G1_04;G1_05;G1_06;G1_07;G1_08;G1_09;G1_10;G1_11',
    '1970' => 'ID;ID_PAI;REG;IND_AP;G3_01;G3_02;G3_03;G3_04;G3_05;G3_06;G3_07;G3_T;G3_08;G3_09',
    '1975' => 'ID;ID_PAI;REG;ALIQ_IMP_BASE;G3_10;G3_11;G3_12',
    '1980' => 'ID;ID_PAI;REG;IND_AP;G4_01;G4_02;G4_03;G4_04;G4_05;G4_06;G4_07;G4_08;G4_09;G4_10;G4_11;G4_12',
    '1990' => 'ID;ID_PAI;REG;QTD_LIN_1',
    '9001' => 'ID;ID_PAI;REG;IND_MOV',
    '9900' => 'ID;ID_PAI;REG;REG_BLC;QTD_REG_BLC',
    '9990' => 'ID;ID_PAI;REG;QTD_LIN_9',
    '9999' => 'ID;ID_PAI;REG;QTD_LIN',
    'B001' => 'ID;ID_PAI;REG;IND_MOV',
    'B020' => 'ID;ID_PAI;REG;IND_OPER;IND_EMIT;COD_PART;COD_MOD;COD_SIT;SER;NUM_DOC;CHV_NFE;DT_DOC;COD_MUN_SERV;VL_CONT;VL_MAT_TERC;VL_SUB;VL_ISNT_ISS;VL_DED_BC;VL_BC_ISS;VL_BC_ISS_RT;VL_ISS_RT;VL_ISS;COD_INF_OBS',
    'B025' => 'ID;ID_PAI;REG;VL_CONT_P;VL_BC_ISS_P;ALIQ_ISS;VL_ISS_P;VL_ISNT_ISS_P;COD_SERV',
    'B030' => 'ID;ID_PAI;REG;COD_MOD;SER;NUM_DOC_INI;NUM_DOC_FIN;DT_DOC;QTD_CANC;VL_CONT;VL_ISNT_ISS;VL_BC_ISS;VL_ISS;COD_INF_OBS',
    'B035' => 'ID;ID_PAI;REG;VL_CONT_P;VL_BC_ISS_P;ALIQ_ISS;VL_ISS_P;VL_ISNT_ISS_P;COD_SERV',
    'B350' => 'ID;ID_PAI;REG;COD_CTD;CTA_ISS;CTA_COSIF;QTD_OCOR;COD_SERV;VL_CONT;VL_BC_ISS;ALIQ_ISS;VL_ISS;COD_INF_OBS',
    'B420' => 'ID;ID_PAI;REG;VL_CONT;VL_BC_ISS;ALIQ_ISS;VL_ISNT_ISS;VL_ISS;COD_SERV',
    'B440' => 'ID;ID_PAI;REG;IND_OPER;COD_PART;VL_CONT_RT;VL_BC_ISS_RT;VL_ISS_RT',
    'B460' => 'ID;ID_PAI;REG;IND_DED;VL_DED;NUM_PROC;IND_PROC;PROC;COD_INF_OBS;IND_OBR',
    'B470' => 'ID;ID_PAI;REG;VL_CONT;VL_MAT_TERC;VL_MAT_PROP;VL_SUB;VL_ISNT;VL_DED_BC;VL_BC_ISS;VL_BC_ISS_RT;VL_ISS;VL_ISS_RT;VL_DED;VL_ISS_REC;VL_ISS_ST;VL_ISS_REC_UNI',
    'B500' => 'ID;ID_PAI;REG;VL_REC;QTD_PROF;VL_OR',
    'B510' => 'ID;ID_PAI;REG;IND_PROF;IND_ESC;IND_SOC;CPF;NOME',
    'B990' => 'ID;ID_PAI;REG;QTD_LIN_B',
    'C001' => 'ID;ID_PAI;REG;IND_MOV',
    'C100' => 'ID;ID_PAI;REG;IND_OPER;IND_EMIT;COD_PART;COD_MOD;COD_SIT;SER;NUM_DOC;CHV_NFE;DT_DOC;DT_E_S;VL_DOC;IND_PGTO;VL_DESC;VL_ABAT_NT;VL_MERC;IND_FRT;VL_FRT;VL_SEG;VL_OUT_DA;VL_BC_ICMS;VL_ICMS;VL_BC_ICMS_ST;VL_ICMS_ST;VL_IPI;VL_PIS;VL_COFINS;VL_PIS_ST;VL_COFINS_ST',
    'C101' => 'ID;ID_PAI;REG;VL_FCP_UF_DEST;VL_ICMS_UF_DEST;VL_ICMS_UF_REM',
    'C105' => 'ID;ID_PAI;REG;OPER;COD_UF',
    'C110' => 'ID;ID_PAI;REG;COD_INF;TXT_COMPL',
    'C111' => 'ID;ID_PAI;REG;NUM_PROC;IND_PROC',
    'C112' => 'ID;ID_PAI;REG;COD_DA;UF;NUM_DA;COD_AUT;VL_DA;DT_VCTO;DT_PGTO',
    'C113' => 'ID;ID_PAI;REG;IND_OPER;IND_EMIT;COD_PART;COD_MOD;SER;SUB;NUM_DOC;DT_DOC;CHV_DOCE',
    'C114' => 'ID;ID_PAI;REG;COD_MOD;ECF_FAB;ECF_CX;NUM_DOC;DT_DOC',
    'C115' => 'ID;ID_PAI;REG;IND_CARGA;CNPJ_COL;IE_COL;CPF_COL;COD_MUN_COL;CNPJ_ENTG;IE_ENTG;CPF_ENTG;COD_MUN_ENTG',
    'C116' => 'ID;ID_PAI;REG;COD_MOD;NR_SAT;CHV_CFE;NUM_CFE;DT_DOC',
    'C120' => 'ID;ID_PAI;REG;COD_DOC_IMP;NUM_DOC_IMP;PIS_IMP;COFINS_IMP;NUM_ACDRAW',
    'C130' => 'ID;ID_PAI;REG;VL_SERV_NT;VL_BC_ISSQN;VL_ISSQN;VL_BC_IRRF;VL_IRRF;VL_BC_PREV;VL_PREV',
    'C140' => 'ID;ID_PAI;REG;IND_EMIT;IND_TIT;DESC_TIT;NUM_TIT;QTD_PARC;VL_TIT',
    'C141' => 'ID;ID_PAI;REG;NUM_PARC;DT_VCTO;VL_PARC',
    'C160' => 'ID;ID_PAI;REG;COD_PART;VEIC_ID;QTD_VOL;PESO_BRT;PESO_LIQ;UF_ID',
    'C165' => 'ID;ID_PAI;REG;COD_PART;VEIC_ID;COD_AUT;NR_PASSE;HORA;TEMPER;QTD_VOL;PESO_BRT;PESO_LIQ;NOM_MOT;CPF;UF_ID',
    'C170' => 'ID;ID_PAI;REG;NUM_ITEM;COD_ITEM;DESCR_COMPL;QTD;UNID;VL_ITEM;VL_DESC;IND_MOV;CST_ICMS;CFOP;COD_NAT;VL_BC_ICMS;ALIQ_ICMS;VL_ICMS;VL_BC_ICMS_ST;ALIQ_ST;VL_ICMS_ST;IND_APUR;CST_IPI;COD_ENQ;VL_BC_IPI;ALIQ_IPI;VL_IPI;CST_PIS;VL_BC_PIS;ALIQ_PIS_PERC;QUANT_BC_PIS;ALIQ_PIS_REAIS;VL_PIS;CST_COFINS;VL_BC_COFINS;ALIQ_COFINS_PERC;QUANT_BC_COFINS;ALIQ_COFINS_REAIS;VL_COFINS;COD_CTA;VL_ABAT_NT',
    'C171' => 'ID;ID_PAI;REG;NUM_TANQUE;QTDE',
    'C172' => 'ID;ID_PAI;REG;VL_BC_ISSQN;ALIQ_ISSQN;VL_ISSQN',
    'C173' => 'ID;ID_PAI;REG;LOTE_MED;QTD_ITEM;DT_FAB;DT_VAL;IND_MED;TP_PROD;VL_TAB_MAX',
    'C174' => 'ID;ID_PAI;REG;IND_ARM;NUM_ARM;DESCR_COMPL',
    'C175' => 'ID;ID_PAI;REG;IND_VEIC_OPER;CNPJ;UF;CHASSI_VEIC',
    'C176' => 'ID;ID_PAI;REG;COD_MOD_ULT_E;NUM_DOC_ULT_E;SER_ULT_E;DT_ULT_E;COD_PART_ULT_E;QUANT_ULT_E;VL_UNIT_ULT_E;VL_UNIT_BC_ST;CHAVE_NFE_ULT_E;NUM_ITEM_ULT_E;VL_UNIT_BC_ICMS_ULT_E;ALIQ_ICMS_ULT_E;VL_UNIT_LIMITE_BC_ICMS_ULT_E;VL_UNIT_ICMS_ULT_E;ALIQ_ST_ULT_E;VL_UNIT_RES;COD_RESP_RET;COD_MOT_RES;CHAVE_NFE_RET;COD_PART_NFE_RET;SER_NFE_RET;NUM_NFE_RET;ITEM_NFE_RET;COD_DA;NUM_DA;VL_UNIT_RES_FCP_ST',
    'C177' => 'ID;ID_PAI;REG;COD_INF_ITEM',
    'C178' => 'ID;ID_PAI;REG;CL_ENQ;VL_UNID;QUANT_PAD',
    'C179' => 'ID;ID_PAI;REG;BC_ST_ORIG_DEST;ICMS_ST_REP;ICMS_ST_COMPL;BC_RET;ICMS_RET',
    'C180' => 'ID;ID_PAI;REG;COD_RESP_RET;QUANT_CONV;UNID;VL_UNIT_CONV;VL_UNIT_ICMS_OP_CONV;VL_UNIT_BC_ICMS_ST_CONV;VL_UNIT_ICMS_ST_CONV;VL_UNIT_FCP_ST_CONV;COD_DA;NUM_DA',
    'C181' => 'ID;ID_PAI;REG;COD_MOT_REST_COMPL;QUANT_CONV;UNID;COD_MOD_SAIDA;SERIE_SAIDA;ECF_FAB_SAIDA;NUM_DOC_SAIDA;CHV_DFE_SAIDA;DT_DOC_SAIDA;NUM_ITEM_SAIDA;VL_UNIT_CONV_SAIDA;VL_UNIT_ICMS_OP_ESTOQUE_CONV_SAIDA;VL_UNIT_ICMS_ST_ESTOQUE_CONV_SAIDA;VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV_SAIDA;VL_UNIT_ICMS_NA_OPERACAO_CONV_SAIDA;VL_UNIT_ICMS_OP_CONV_SAIDA;VL_UNIT_ICMS_ST_CONV_REST;VL_UNIT_FCP_ST_CONV_REST;VL_UNIT_ICMS_ST_CONV_COMPL;VL_UNIT_FCP_ST_CONV_COMPL',
    'C185' => 'ID;ID_PAI;REG;NUM_ITEM;COD_ITEM;CST_ICMS;CFOP;COD_MOT_REST_COMPL;QUANT_CONV;UNID;VL_UNIT_CONV;VL_UNIT_ICMS_NA_OPERACAO_CONV;VL_UNIT_ICMS_OP_CONV;VL_UNIT_ICMS_OP_ESTOQUE_CONV;VL_UNIT_ICMS_ST_ESTOQUE_CONV;VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;VL_UNIT_ICMS_ST_CONV_REST;VL_UNIT_FCP_ST_CONV_REST;VL_UNIT_ICMS_ST_CONV_COMPL;VL_UNIT_FCP_ST_CONV_COMPL',
    'C186' => 'ID;ID_PAI;REG;NUM_ITEM;COD_ITEM;CST_ICMS;CFOP;COD_MOT_REST_COMPL;QUANT_CONV;UNID;COD_MOD_ENTRADA;SERIE_ENTRADA;NUM_DOC_ENTRADA;CHV_DFE_ENTRADA;DT_DOC_ENTRADA;NUM_ITEM_ENTRADA;VL_UNIT_CONV_ENTRADA;VL_UNIT_ICMS_OP_CONV_ENTRADA;VL_UNIT_BC_ICMS_ST_CONV_ENTRADA;VL_UNIT_ICMS_ST_CONV_ENTRADA;VL_UNIT_FCP_ST_CONV_ENTRADA',
    'C190' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ICMS;VL_ICMS;VL_BC_ICMS_ST;VL_ICMS_ST;VL_RED_BC;VL_IPI;COD_OBS',
    'C191' => 'ID;ID_PAI;REG;VL_FCP_OP;VL_FCP_ST;VL_FCP_RET',
    'C195' => 'ID;ID_PAI;REG;COD_OBS;TXT_COMPL',
    'C197' => 'ID;ID_PAI;REG;COD_AJ;DESCR_COMPL_AJ;COD_ITEM;VL_BC_ICMS;ALIQ_ICMS;VL_ICMS;VL_OUTROS',
    'C300' => 'ID;ID_PAI;REG;COD_MOD;SER;SUB;NUM_DOC_INI;NUM_DOC_FIN;DT_DOC;VL_DOC;VL_PIS;VL_COFINS;COD_CTA',
    'C310' => 'ID;ID_PAI;REG;NUM_DOC_CANC',
    'C320' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ICMS;VL_ICMS;VL_RED_BC;COD_OBS',
    'C321' => 'ID;ID_PAI;REG;COD_ITEM;QTD;UNID;VL_ITEM;VL_DESC;VL_BC_ICMS;VL_ICMS;VL_PIS;VL_COFINS',
    'C330' => 'ID;ID_PAI;REG;COD_MOT_REST_COMPL;QUANT_CONV;UNID;VL_UNIT_CONV;VL_UNIT_ICMS_NA_OPERACAO_CONV;VL_UNIT_ICMS_OP_CONV;VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;VL_UNIT_ICMS_ST_ESTOQUE_CONV;VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;VL_UNIT_ICMS_ST_CONV_REST;VL_UNIT_FCP_ST_CONV_REST;VL_UNIT_ICMS_ST_CONV_COMPL;VL_UNIT_FCP_ST_CONV_COMPL',
    'C350' => 'ID;ID_PAI;REG;SER;SUB_SER;NUM_DOC;DT_DOC;CNPJ_CPF;VL_MERC;VL_DOC;VL_DESC;VL_PIS;VL_COFIS;COD_CTA',
    'C370' => 'ID;ID_PAI;REG;NUM_ITEM;COD_ITEM;QTD;UNID;VL_ITEM;VL_DESC',
    'C380' => 'ID;ID_PAI;REG;COD_MOT_REST_COMPL;QUANT_CONV;UNID;VL_UNIT_CONV;VL_UNIT_ICMS_NA_OPERACAO_CONV;VL_UNIT_ICMS_OP_CONV;VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;VL_UNIT_ICMS_ST_ESTOQUE_CONV;VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;VL_UNIT_ICMS_ST_CONV_REST;VL_UNIT_FCP_ST_CONV_REST;VL_UNIT_ICMS_ST_CONV_COMPL;VL_UNIT_FCP_ST_CONV_COMPL;CST_ICMS;CFOP',
    'C390' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ICMS;VL_ICMS;VL_RED_BC;COD_OBS',
    'C400' => 'ID;ID_PAI;REG;COD_MOD;ECF_MOD;ECF_FAB;ECF_CX',
    'C405' => 'ID;ID_PAI;REG;DT_DOC;CRO;CRZ;NUM_COO_FIN;GT_FIN;VL_BRT',
    'C410' => 'ID;ID_PAI;REG;VL_PIS;VL_COFINS',
    'C420' => 'ID;ID_PAI;REG;COD_TOT_PAR;VLR_ACUM_TOT;NR_TOT;DESCR_NR_TOT',
    'C425' => 'ID;ID_PAI;REG;COD_ITEM;QTD;UNID;VL_ITEM;VL_PIS;VL_COFINS',
    'C430' => 'ID;ID_PAI;REG;COD_MOT_REST_COMPL;QUANT_CONV;UNID;VL_UNIT_CONV;VL_UNIT_ICMS_NA_OPERACAO_CONV;VL_UNIT_ICMS_OP_CONV;VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;VL_UNIT_ICMS_ST_ESTOQUE_CONV;VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;VL_UNIT_ICMS_ST_CONV_REST;VL_UNIT_FCP_ST_CONV_REST;VL_UNIT_ICMS_ST_CONV_COMPL;VL_UNIT_FCP_ST_CONV_COMPL;CST_ICMS;CFOP',
    'C460' => 'ID;ID_PAI;REG;COD_MOD;COD_SIT;NUM_DOC;DT_DOC;VL_DOC;VL_PIS;VL_COFINS;CPF_CNPJ;NOME_ADQ',
    'C465' => 'ID;ID_PAI;REG;CHV_CFE;NUM_CCF',
    'C470' => 'ID;ID_PAI;REG;COD_ITEM;QTD;QTD_CANC;UNID;VL_ITEM;CST_ICMS;CFOP;ALIQ_ICMS;VL_PIS;VL_COFINS',
    'C480' => 'ID;ID_PAI;REG;COD_MOT_REST_COMPL;QUANT_CONV;UNID;VL_UNIT_CONV;VL_UNIT_ICMS_NA_OPERACAO_CONV;VL_UNIT_ICMS_OP_CONV;VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;VL_UNIT_ICMS_ST_ESTOQUE_CONV;VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;VL_UNIT_ICMS_ST_CONV_REST;VL_UNIT_FCP_ST_CONV_REST;VL_UNIT_ICMS_ST_CONV_COMPL;VL_UNIT_FCP_ST_CONV_COMPL;CST_ICMS;CFOP',
    'C490' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ICMS;VL_ICMS;COD_OBS',
    'C500' => 'ID;ID_PAI;REG;IND_OPER;IND_EMIT;COD_PART;COD_MOD;COD_SIT;SER;SUB;COD_CONS;NUM_DOC;DT_DOC;DT_E_S;VL_DOC;VL_DESC;VL_FORN;VL_SERV_NT;VL_TERC;VL_DA;VL_BC_ICMS;VL_ICMS;VL_BC_ICMS_ST;VL_ICMS_ST;COD_INF;VL_PIS;VL_COFINS;TP_LIGACAO;COD_GRUPO_TENSAO;CHV_DOCE;FIN_DOCE;CHV_DOCE_REF;IND_DEST;COD_MUN_DEST;COD_CTA;COD_MOD_DOC_REF;HASH_DOC_REF;SER_DOC_REF;NUM_DOC_REF;MES_DOC_REF;ENER_INJET;OUTRAS_DED',
    'C510' => 'ID;ID_PAI;REG;NUM_ITEM;COD_ITEM;COD_CLASS;QTD;UNID;VL_ITEM;VL_DESC;CST_ICMS;CFOP;VL_BC_ICMS;ALIQ_ICMS;VL_ICMS;VL_BC_ICMS_ST;ALIQ_ST;VL_ICMS_ST;IND_REC;COD_PART;VL_PIS;VL_COFINS;COD_CTA',
    'C590' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ICMS;VL_ICMS;VL_BC_ICMS_ST;VL_ICMS_ST;VL_RED_BC;COD_OBS',
    'C591' => 'ID;ID_PAI;REG;VL_FCP_OP;VL_FCP_ST',
    'C595' => 'ID;ID_PAI;REG;COD_OBS;TXT_COMPL',
    'C597' => 'ID;ID_PAI;REG;COD_AJ;DESCR_COMPL_AJ;COD_ITEM;VL_BC_ICMS;ALIQ_ICMS;VL_ICMS;VL_OUTROS',
    'C600' => 'ID;ID_PAI;REG;COD_MOD;COD_MUN;SER;SUB;COD_CONS;QTD_CONS;QTD_CANC;DT_DOC;VL_DOC;VL_DESC;CONS;VL_FORN;VL_SERV_NT;VL_TERC;VL_DA;VL_BC_ICMS;VL_ICMS;VL_BC_ICMS_ST;VL_ICMS_ST;VL_PIS;VL_COFINS',
    'C601' => 'ID;ID_PAI;REG;NUM_DOC_CANC',
    'C610' => 'ID;ID_PAI;REG;COD_CLASS;COD_ITEM;QTD;UNID;VL_ITEM;VL_DESC;CST_ICMS;CFOP;ALIQ_ICMS;VL_BC_ICMS;VL_ICMS;VL_BC_ICMS_ST;VL_ICMS_ST;VL_PIS;VL_COFINS;COD_CTA',
    'C690' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ICMS;VL_ICMS;VL_RED_BC;VL_BC_ICMS_ST;VL_ICMS_ST;COD_OBS',
    'C700' => 'ID;ID_PAI;REG;COD_MOD;SER;NRO_ORD_INI;NRO_ORD_FIN;DT_DOC_INI;DT_DOC_FIN;NOM_MEST;CHV_COD_DIG',
    'C790' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ICMS;VL_ICMS;VL_BC_ICMS_ST;VL_ICMS_ST;VL_RED_BC;COD_OBS',
    'C791' => 'ID;ID_PAI;REG;UF;VL_BC_ICMS_ST;VL_ICMS_ST',
    'C800' => 'ID;ID_PAI;REG;COD_MOD;COD_SIT;NUM_CFE;DT_DOC;VL_CFE;VL_PIS;VL_COFINS;CNPJ_CPF;NR_SAT;CHV_CFE;VL_DESC;VL_MERC;VL_OUT_DA;VL_ICMS;VL_PIS_ST;VL_COFINS_ST',
    'C810' => 'ID;ID_PAI;REG;NUM_ITEM;COD_ITEM;QTD;UNID;VL_ITEM;CST_ICMS;CFOP',
    'C815' => 'ID;ID_PAI;REG;COD_MOT_REST_COMPL;QUANT_CONV;UNID;VL_UNIT_CONV;VL_UNIT_ICMS_NA_OPERACAO_CONV;VL_UNIT_ICMS_OP_CONV;VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;VL_UNIT_ICMS_ST_ESTOQUE_CONV;VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;VL_UNIT_ICMS_ST_CONV_REST;VL_UNIT_FCP_ST_CONV_REST;VL_UNIT_ICMS_ST_CONV_COMPL;VL_UNIT_FCP_ST_CONV_COMPL',
    'C850' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ICMS;VL_ICMS;COD_OBS',
    'C855' => 'ID;ID_PAI;REG;COD_OBS;TXT_COMPL',
    'C857' => 'ID;ID_PAI;REG;COD_AJ;DESCR_COMPL_AJ;COD_ITEM;VL_BC_ICMS;ALIQ_ICMS;VL_ICMS;VL_OUTROS',
    'C860' => 'ID;ID_PAI;REG;COD_MOD;NR_SAT;DT_DOC;DOC_INI;DOC_FIM',
    'C870' => 'ID;ID_PAI;REG;COD_ITEM;QTD;UNID;CST_ICMS;CFOP',
    'C880' => 'ID;ID_PAI;REG;COD_MOT_REST_COMPL;QUANT_CONV;UNID;VL_UNIT_CONV;VL_UNIT_ICMS_NA_OPERACAO_CONV;VL_UNIT_ICMS_OP_CONV;VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;VL_UNIT_ICMS_ST_ESTOQUE_CONV;VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;VL_UNIT_ICMS_ST_CONV_REST;VL_UNIT_FCP_ST_CONV_REST;VL_UNIT_ICMS_ST_CONV_COMPL;VL_UNIT_FCP_ST_CONV_COMPL',
    'C890' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ICMS;VL_ICMS;COD_OBS',
    'C895' => 'ID;ID_PAI;REG;COD_OBS;TXT_COMPL',
    'C897' => 'ID;ID_PAI;REG;COD_AJ;DESCR_COMPL_AJ;COD_ITEM;VL_BC_ICMS;ALIQ_ICMS;VL_ICMS;VL_OUTROS',
    'C990' => 'ID;ID_PAI;REG;QTD_LIN_C',
    'D001' => 'ID;ID_PAI;REG;IND_MOV',
    'D100' => 'ID;ID_PAI;REG;IND_OPER;IND_EMIT;COD_PART;COD_MOD;COD_SIT;SER;SUB;NUM_DOC;CHV_CTE;DT_DOC;DT_A_P;TP_CT_E;CHV_CTE_REF;VL_DOC;VL_DESC;IND_FRT;VL_SERV;VL_BC_ICMS;VL_ICMS;VL_NT;COD_INF;COD_CTA;COD_MUN_ORIG;COD_MUN_DEST',
    'D101' => 'ID;ID_PAI;REG;VL_FCP_UF_DEST;VL_ICMS_UF_DEST;VL_ICMS_UF_REM',
    'D110' => 'ID;ID_PAI;REG;NUM_ITEM;COD_ITEM;VL_SERV;VL_OUT',
    'D120' => 'ID;ID_PAI;REG;COD_MUN_ORIG;COD_MUN_DEST;VEIC_ID;UF_ID',
    'D130' => 'ID;ID_PAI;REG;COD_PART_CONSG;COD_PART_RED;IND_FRT_RED;COD_MUN_ORIG;COD_MUN_DEST;VEIC_ID;VL_LIQ_FRT;VL_SEC_CAT;VL_DESP;VL_PEDG;VL_OUT;VL_FRT;UF_ID',
    'D140' => 'ID;ID_PAI;REG;COD_PART_CONSG;COD_MUN_ORIG;COD_MUN_DEST;IND_VEIC;VEIC_ID;IND_NAV;VIAGEM;VL_FRT_LIQ;VL_DESP_PORT;VL_DESP_CAR_DESC;VL_OUT;VL_FRT_BRT;VL_FRT_MM',
    'D150' => 'ID;ID_PAI;REG;COD_MUN_ORIG;COD_MUN_DEST;VEIC_ID;VIAGEM;IND_TFA;VL_PESO_TX;VL_TX_TERR;VL_TX_RED;VL_OUT;VL_TX_ADV',
    'D160' => 'ID;ID_PAI;REG;DESPACHO;CNPJ_CPF_REM;IE_REM;COD_MUN_ORI;CNPJ_CPF_DEST;IE_DEST;COD_MUN_DEST',
    'D161' => 'ID;ID_PAI;REG;IND_CARGA;CNPJ_CPF_COL;IE_COL;COD_MUN_COL;CNPJ_CPF_ENTG;IE_ENTG;COD_MUN_ENTG',
    'D162' => 'ID;ID_PAI;REG;COD_MOD;SER;NUM_DOC;DT_DOC;VL_DOC;VL_MERC;QTD_VOL;PESO_BRT;PESO_LIQ',
    'D170' => 'ID;ID_PAI;REG;COD_PART_CONSG;COD_PART_RED;COD_MUN_ORIG;COD_MUN_DEST;OTM;IND_NAT_FRT;VL_LIQ_FRT;VL_GRIS;VL_PDG;VL_OUT;VL_FRT;VEIC_ID;UF_ID',
    'D180' => 'ID;ID_PAI;REG;NUM_SEQ;IND_EMIT;CNPJ_CPF_EMIT;UF_EMIT;IE_EMIT;COD_MUN_ORIG;CNPJ_CPF_TOM;UF_TOM;IE_TOM;COD_MUN_DEST;COD_MOD;SER;SUB;NUM_DOC;DT_DOC;VL_DOC',
    'D190' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ICMS;VL_ICMS;VL_RED_BC;COD_OBS',
    'D195' => 'ID;ID_PAI;REG;COD_OBS;TXT_COMPL',
    'D197' => 'ID;ID_PAI;REG;COD_AJ;DESCR_COMPL_AJ;COD_ITEM;VL_BC_ICMS;ALIQ_ICMS;VL_ICMS;VL_OUTROS',
    'D300' => 'ID;ID_PAI;REG;COD_MOD;SER;SUB;NUM_DOC_INI;NUM_DOC_FIN;CST_ICMS;CFOP;ALIQ_ICMS;DT_DOC;VL_OPR;VL_DESC;VL_SERV;VL_SEG;VL_OUT_DESP;VL_BC_ICMS;VL_ICMS;VL_RED_BC;COD_OBS;COD_CTA',
    'D301' => 'ID;ID_PAI;REG;NUM_DOC_CANC',
    'D310' => 'ID;ID_PAI;REG;COD_MUN_ORIG;VL_SERV;VL_BC_ICMS;VL_ICMS',
    'D350' => 'ID;ID_PAI;REG;COD_MOD;ECF_MOD;ECF_FAB;ECF_CX',
    'D355' => 'ID;ID_PAI;REG;DT_DOC;CRO;CRZ;NUM_COO_FIN;GT_FIN;VL_BRT',
    'D360' => 'ID;ID_PAI;REG;VL_PIS;VL_COFINS',
    'D365' => 'ID;ID_PAI;REG;COD_TOT_PAR;VLR_ACUM_TOT;NR_TOT;DESCR_NR_TOT',
    'D370' => 'ID;ID_PAI;REG;COD_MUN_ORIG;VL_SERV;QTD_BILH;VL_BC_ICMS;VL_ICMS',
    'D390' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ISSQN;ALIQ_ISSQN;VL_ISSQN;VL_BC_ICMS;VL_ICMS;COD_OBS',
    'D400' => 'ID;ID_PAI;REG;COD_PART;COD_MOD;COD_SIT;SER;SUB;NUM_DOC;DT_DOC;VL_DOC;VL_DESC;VL_SERV;VL_BC_ICMS;VL_ICMS;VL_PIS;VL_COFINS;COD_CTA',
    'D410' => 'ID;ID_PAI;REG;COD_MOD;SER;SUB;NUM_DOC_INI;NUM_DOC_FIN;DT_DOC;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_DESC;VL_SERV;VL_BC_ICMS;VL_ICMS',
    'D411' => 'ID;ID_PAI;REG;NUM_DOC_CANC',
    'D420' => 'ID;ID_PAI;REG;COD_MUN_ORIG;VL_SERV;VL_BC_ICMS;VL_ICMS',
    'D500' => 'ID;ID_PAI;REG;IND_OPER;IND_EMIT;COD_PART;COD_MOD;COD_SIT;SER;SUB;NUM_DOC;DT_DOC;DT_A_P;VL_DOC;VL_DESC;VL_SERV;VL_SERV_NT;VL_TERC;VL_DA;VL_BC_ICMS;VL_ICMS;COD_INF;VL_PIS;VL_COFINS;COD_CTA;TP_ASSINANTE',
    'D510' => 'ID;ID_PAI;REG;NUM_ITEM;COD_ITEM;COD_CLASS;QTD;UNID;VL_ITEM;VL_DESC;CST_ICMS;CFOP;VL_BC_ICMS;ALIQ_ICMS;VL_ICMS;VL_BC_ICMS_ST;VL_ICMS_ST;IND_REC;COD_PART;VL_PIS;VL_COFINS;COD_CTA',
    'D530' => 'ID;ID_PAI;REG;IND_SERV;DT_INI_SERV;DT_FIN_SERV;PER_FISCAL;COD_AREA;TERMINAL',
    'D590' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ICMS;VL_ICMS;VL_BC_ICMS_ST;VL_ICMS_ST;VL_RED_BC;COD_OBS',
    'D600' => 'ID;ID_PAI;REG;COD_MOD;COD_MUN;SER;SUB;COD_CONS;QTD_CONS;DT_DOC;VL_DOC;VL_DESC;VL_SERV;VL_SERV_NT;VL_TERC;VL_DA;VL_BC_ICMS;VL_ICMS;VL_PIS;VL_COFINS',
    'D610' => 'ID;ID_PAI;REG;COD_CLASS;COD_ITEM;QTD;UNID;VL_ITEM;VL_DESC;CST_ICMS;CFOP;ALIQ_ICMS;VL_BC_ICMS;VL_ICMS;VL_BC_ICMS_ST;VL_ICMS_ST;VL_RED_BC;VL_PIS;VL_COFINS;COD_CTA',
    'D690' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ICMS;VL_ICMS;VL_BC_ICMS_ST;VL_ICMS_ST;VL_RED_BC;COD_OBS',
    'D695' => 'ID;ID_PAI;REG;COD_MOD;SER;NRO_ORD_INI;NRO_ORD_FIN;DT_DOC_INI;DT_DOC_FIN;NOM_MEST;CHV_COD_DIG',
    'D696' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ICMS;VL_ICMS;VL_BC_ICMS_ST;VL_ICMS_ST;VL_RED_BC;COD_OBS',
    'D697' => 'ID;ID_PAI;REG;UF;VL_BC_ICMS_ST;VL_ICMS_ST',
    'D700' => 'ID;ID_PAI;REG;IND_OPER;IND_EMIT;COD_PART;COD_MOD;COD_SIT;SER;NUM_DOC;DT_DOC;DT_A_P;VL_DOC;VL_DESC;VL_SERV;VL_SERV_NT;VL_TERC;VL_DA;VL_BC_ICMS;VL_ICMS;COD_INF;VL_PIS;VL_COFINS;CHV_DOCE;FIN_DOCE;TIP_FAT;COD_MOD_DOC_REF;CHV_DOCE_REF;HASH_DOC_REF;SER_DOC_REF;NUM_DOC_REF;MES_DOC_REF;COD_MUN_DEST',
    'D730' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ICMS;VL_ICMS;VL_RED_BC;COD_OBS',
    'D731' => 'ID;ID_PAI;REG;VL_FCP_OP',
    'D735' => 'ID;ID_PAI;REG;COD_OBS;TXT_COMPL',
    'D737' => 'ID;ID_PAI;REG;COD_AJ;DESCR_COMPL_AJ;COD_ITEM;VL_BC_ICMS;ALIQ_ICMS;VL_ICMS;VL_OUTROS',
    'D750' => 'ID;ID_PAI;REG;COD_MOD;SER;DT_DOC;QTD_CONS;IND_PREPAGO;VL_DOC;VL_SERV;VL_SERV_NT;VL_TERC;VL_DESC;VL_DA;VL_BC_ICMS;VL_ICMS;VL_PIS;VL_COFINS',
    'D760' => 'ID;ID_PAI;REG;CST_ICMS;CFOP;ALIQ_ICMS;VL_OPR;VL_BC_ICMS;VL_ICMS;VL_RED_BC;COD_OBS',
    'D761' => 'ID;ID_PAI;REG;VL_FCP_OP',
    'D990' => 'ID;ID_PAI;REG;QTD_LIN_D',
    'E001' => 'ID;ID_PAI;REG;IND_MOV',
    'E100' => 'ID;ID_PAI;REG;DT_INI;DT_FIN',
    'E110' => 'ID;ID_PAI;REG;VL_TOT_DEBITOS;VL_AJ_DEBITOS;VL_TOT_AJ_DEBITOS;VL_ESTORNOS_CRED;VL_TOT_CREDITOS;VL_AJ_CREDITOS;VL_TOT_AJ_CREDITOS;VL_ESTORNOS_DEB;VL_SLD_CREDOR_ANT;VL_SLD_APURADO;VL_TOT_DED;VL_ICMS_RECOLHER;VL_SLD_CREDOR_TRANSPORTAR;DEB_ESP',
    'E111' => 'ID;ID_PAI;REG;COD_AJ_APUR;DESCR_COMPL_AJ;VL_AJ_APUR',
    'E112' => 'ID;ID_PAI;REG;NUM_DA;NUM_PROC;IND_PROC;PROC;TXT_COMPL',
    'E113' => 'ID;ID_PAI;REG;COD_PART;COD_MOD;SER;SUB;NUM_DOC;DT_DOC;COD_ITEM;VL_AJ_ITEM;CHV_DOCE',
    'E115' => 'ID;ID_PAI;REG;COD_INF_ADIC;VL_INF_ADIC;DESCR_COMPL_AJ',
    'E116' => 'ID;ID_PAI;REG;COD_OR;VL_OR;DT_VCTO;COD_REC;NUM_PROC;IND_PROC;PROC;TXT_COMPL;MES_REF',
    'E200' => 'ID;ID_PAI;REG;UF;DT_INI;DT_FIN',
    'E210' => 'ID;ID_PAI;REG;IND_MOV_ST;VL_SLD_CRED_ANT_ST;VL_DEVOL_ST;VL_RESSARC_ST;VL_OUT_CRED_ST;VL_AJ_CREDITOS_ST;VL_RETENCAO_ST;VL_OUT_DEB_ST;VL_AJ_DEBITOS_ST;VL_SLD_DEV_ANT_ST;VL_DEDUCOES_ST;VL_ICMS_RECOL_ST;VL_SLD_CRED_ST_TRANSPORTAR;DEB_ESP_ST',
    'E220' => 'ID;ID_PAI;REG;COD_AJ_APUR;DESCR_COMPL_AJ;VL_AJ_APUR',
    'E230' => 'ID;ID_PAI;REG;NUM_DA;NUM_PROC;IND_PROC;PROC;TXT_COMPL',
    'E240' => 'ID;ID_PAI;REG;COD_PART;COD_MOD;SER;SUB;NUM_DOC;DT_DOC;COD_ITEM;VL_AJ_ITEM;CHV_DOCE',
    'E250' => 'ID;ID_PAI;REG;COD_OR;VL_OR;DT_VCTO;COD_REC;NUM_PROC;IND_PROC;PROC;TXT_COMPL;MES_REF',
    'E300' => 'ID;ID_PAI;REG;UF;DT_INI;DT_FIN',
    'E310' => 'ID;ID_PAI;REG;IND_MOV_DIFAL;VL_SLD_CRED_ANT_DIFAL;VL_TOT_DEBITOS_DIFAL;VL_OUT_DEB_DIFAL;VL_TOT_CREDITOS_DIFAL;VL_OUT_CRED_DIFAL;VL_SLD_DEV_ANT_DIFAL;VL_DEDUCOES_DIFAL;VL_RECOL;VL_SLD_CRED_TRANSPORTAR;DEB_ESP_DIFAL;VL_SLD_CRED_ANT_FCP;VL_TOT_DEB_FCP;VL_OUT_DEB_FCP;VL_TOT_CRED_FCP;VL_OUT_CRED_FCP;VL_SLD_DEV_ANT_FCP;VL_DEDUCOES_FCP;VL_RECOL_FCP;VL_SLD_CRED_TRANSPORTAR_FCP;DEB_ESP_FCP',
    'E311' => 'ID;ID_PAI;REG;COD_AJ_APUR;DESCR_COMPL_AJ;VL_AJ_APUR',
    'E312' => 'ID;ID_PAI;REG;NUM_DA;NUM_PROC;IND_PROC;PROC;TXT_COMPL',
    'E313' => 'ID;ID_PAI;REG;COD_PART;COD_MOD;SER;SUB;NUM_DOC;CHV_DOCE;DT_DOC;COD_ITEM;VL_AJ_ITEM',
    'E316' => 'ID;ID_PAI;REG;COD_OR;VL_OR;DT_VCTO;COD_REC;NUM_PROC;IND_PROC;PROC;TXT_COMPL;MES_REF',
    'E500' => 'ID;ID_PAI;REG;IND_APUR;DT_INI;DT_FIN',
    'E510' => 'ID;ID_PAI;REG;CFOP;CST_IPI;VL_CONT_IPI;VL_BC_IPI;VL_IPI',
    'E520' => 'ID;ID_PAI;REG;VL_SD_ANT_IPI;VL_DEB_IPI;VL_CRED_IPI;VL_OD_IPI;VL_OC_IPI;VL_SC_IPI;VL_SD_IPI',
    'E530' => 'ID;ID_PAI;REG;IND_AJ;VL_AJ;COD_AJ;IND_DOC;NUM_DOC;DESCR_AJ',
    'E531' => 'ID;ID_PAI;REG;COD_PART;COD_MOD;SER;SUB;NUM_DOC;DT_DOC;COD_ITEM;VL_AJ_ITEM;CHV_NFE',
    'E990' => 'ID;ID_PAI;REG;QTD_LIN_E',
    'G001' => 'ID;ID_PAI;REG;IND_MOV',
    'G110' => 'ID;ID_PAI;REG;DT_INI;DT_FIN;SALDO_IN_ICMS;SOM_PARC;VL_TRIB_EXP;VL_TOTAL;IND_PER_SAI;ICMS_APROP;SOM_ICMS_OC',
    'G125' => 'ID;ID_PAI;REG;COD_IND_BEM;DT_MOV;TIPO_MOV;VL_IMOB_ICMS_OP;VL_IMOB_ICMS_ST;VL_IMOB_ICMS_FRT;VL_IMOB_ICMS_DIF;NUM_PARC;VL_PARC_PASS',
    'G126' => 'ID;ID_PAI;REG;DT_INI;DT_FIN;NUM_PARC;VL_PARC_PASS;VL_TRIB_OC;VL_TOTAL;IND_PER_SAI;VL_PARC_APROP',
    'G130' => 'ID;ID_PAI;REG;IND_EMIT;COD_PART;COD_MOD;SERIE;NUM_DOC;CHV_NFE_CTE;DT_DOC;NUM_DA',
    'G140' => 'ID;ID_PAI;REG;NUM_ITEM;COD_ITEM;QTDE;UNID;VL_ICMS_OP_APLICADO;VL_ICMS_ST_APLICADO;VL_ICMS_FRT_APLICADO;VL_ICMS_DIF_APLICADO',
    'G990' => 'ID;ID_PAI;REG;QTD_LIN_G',
    'H001' => 'ID;ID_PAI;REG;IND_MOV',
    'H005' => 'ID;ID_PAI;REG;DT_INV;VL_INV;MOT_INV',
    'H010' => 'ID;ID_PAI;REG;COD_ITEM;UNID;QTD;VL_UNIT;VL_ITEM;IND_PROP;COD_PART;TXT_COMPL;COD_CTA;VL_ITEM_IR',
    'H020' => 'ID;ID_PAI;REG;CST_ICMS;BL_ICMS;VL_ICMS',
    'H030' => 'ID;ID_PAI;REG;VL_ICMS_OP;VL_BC_ICMS_ST;VL_ICMS_ST;VL_FCP',
    'H990' => 'ID;ID_PAI;REG;QTD_LIN_H',
    'K001' => 'ID;ID_PAI;REG;IND_MOV',
    'K010' => 'ID;ID_PAI;REG;IND_TP_LEIAUTE',
    'K100' => 'ID;ID_PAI;REG;DT_INI;DT_FIN',
    'K200' => 'ID;ID_PAI;REG;DT_EST;COD_ITEM;QTD;IND_EST;COD_PART',
    'K210' => 'ID;ID_PAI;REG;DT_INI_OS;DT_FIN_OS;COD_DOC_OS;COD_ITEM_ORI;QTD_ORI',
    'K215' => 'ID;ID_PAI;REG;COD_ITEM_DEST;QTD_DES',
    'K220' => 'ID;ID_PAI;REG;DT_MOV;COD_ITEM_ORI;COD_ITEM_DEST;QTD_ORI;QTD_DEST',
    'K230' => 'ID;ID_PAI;REG;DT_INI_OP;DT_FIN_OP;COD_DOC_OP;COD_ITEM;QTD_ENC',
    'K235' => 'ID;ID_PAI;REG;DT_SAIDA;COD_ITEM;QTD;COD_INS_SUBST',
    'K250' => 'ID;ID_PAI;REG;DT_PROD;COD_ITEM;QTD',
    'K255' => 'ID;ID_PAI;REG;DT_CONS;COD_ITEM;QTD;COD_INS_SUBST',
    'K260' => 'ID;ID_PAI;REG;COD_OP_OS;COD_ITEM;DT_SAIDA;QTD_SAIDA;DT_RET;QTD_RET',
    'K265' => 'ID;ID_PAI;REG;COD_ITEM;QTD_CONS;QTD_RET',
    'K270' => 'ID;ID_PAI;REG;DT_INI_AP;DT_FIN_AP;COD_OP_OS;COD_ITEM;QTD_COR_POS;QTD_COR_NEG;ORIGEM',
    'K275' => 'ID;ID_PAI;REG;COD_ITEM;QTD_COR_POS;QTD_COR_NEG;COD_INS_SUBST',
    'K280' => 'ID;ID_PAI;REG;DT_EST;COD_ITEM;QTD_COR_POS;QTD_COR_NEG;IND_EST;COD_PART',
    'K290' => 'ID;ID_PAI;REG;DT_INI_OP;DT_FIN_OP;COD_DOC_OP',
    'K291' => 'ID;ID_PAI;REG;COD_ITEM;QTD',
    'K292' => 'ID;ID_PAI;REG;COD_ITEM;QTD',
    'K300' => 'ID;ID_PAI;REG;DT_PROD',
    'K301' => 'ID;ID_PAI;REG;COD_ITEM;QTD',
    'K302' => 'ID;ID_PAI;REG;COD_ITEM;QTD',
    'K990' => 'ID;ID_PAI;REG;QTD_LIN_K'
];


if($result){
    foreach($result as $r){

        $stylesHeader = array( 'font'=>'Arial','font-size'=>10,'font-style'=>'bold', 'fill'=>'#eee', 'halign'=>'center', 'border'=>'left,right,top,bottom');

        $handle = fopen($r->sped_arquivo_fiscal, 'r');
        if($handle){
            while(!feof($handle)){
                $rowArq = fgets($handle);

                $explode_line = explode('|', $rowArq);
                $count_line = count($explode_line) - 1;

                echo '<pre>';
                print_r($explode_line);

                unset($explode_line[$count_line]);
                unset($explode_line['0']);

                if(isset(BLOCO_SPED_FISCAL[$explode_line[1]])){
                    $fieldsUsed[$explode_line[1]]   = $explode_line[1];
                    $headerStreet[$explode_line[1]] = explode(';', BLOCO_SPED_FISCAL[$explode_line[1]]);
                    $rowsStreet[$explode_line[1]][] = $explode_line;
                }

            }
        }

        $writer = new XLSXWriter();
        if($fieldsUsed){
            if(count($fieldsUsed) > 0){
                foreach($fieldsUsed as $codes => $codesUsed){
                    if($rowsStreet[$codesUsed]){
                        if(count($rowsStreet[$codesUsed]) > 0){
                            for($x=0;$x<count($headerStreet[$codesUsed]);$x++){
                                $headerStreetUse[$codesUsed][$headerStreet[$codesUsed][$x]] = 'string';
                            }

                            $writer->writeSheetHeader($codesUsed, $headerStreetUse[$codesUsed], $stylesHeader);

                            foreach($rowsStreet[$codesUsed] as $row)
                                $writer->writeSheetRow($codesUsed, $row);
                        }
                    }
                }
            }
        }
        $nameDoc = rand(1000,9999).'.xlsx';
        //$writer->writeToFile($nameDoc);

    }
}
